/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.info.pm;

import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.SafeTransactionReporter;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.evv.Role;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.ui.dialog.info.pm.ConnectionChecker;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplay;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JButton;

public final class InfoDialogPm {
    private final Window parent;
    private final JButton OKbutton;
    private final IconDisplay downloadDisplay;
    private final IconDisplay transSoftDisplay;
    private final IconDisplay ezvProdDisplay;
    private final IconDisplay ezvTestDisplay;
    private final IconDisplay transactionBacklogIconDisplay;

    public InfoDialogPm(Window parent) {
        this.parent = parent;
        this.OKbutton = new JButton(Services.getText(212));
        this.downloadDisplay = this.createUndecided();
        this.transSoftDisplay = this.createUndecided();
        this.ezvProdDisplay = this.createUndecided();
        this.ezvTestDisplay = this.createUndecided();
        this.transactionBacklogIconDisplay = this.createUndecided();
        this.createDownloadChecker().execute();
    }

    private ConnectionChecker createDownloadChecker() {
        return new ConnectionChecker(this.createTransSoftChecker(), this.parent, this.downloadDisplay, () -> {
            URL url = new URI("https://launcher.expovit-edec.ch/run.jnlp").toURL();
            InputStream stream = url.openStream();
            FileUtil.close(stream);
        });
    }

    private ConnectionChecker createTransSoftChecker() {
        return new ConnectionChecker(this.createEZVProdChecker(), this.parent, this.transSoftDisplay, () -> {
            try {
                CustomerManagementFacade.getStateInfo("no guid");
            }
            catch (UnknownGuidException unknownGuidException) {
                // empty catch block
            }
        });
    }

    private ConnectionChecker createEZVProdChecker() {
        return new ConnectionChecker(this.createEZVTestChecker(), this.parent, this.ezvProdDisplay, () -> this.testEzvConnection(OperatingMode.production));
    }

    private ConnectionChecker createEZVTestChecker() {
        return new ConnectionChecker(this.createBacklogChecker(), this.parent, this.ezvTestDisplay, () -> this.testEzvConnection(OperatingMode.test));
    }

    private void testEzvConnection(OperatingMode test) throws Exception {
        if (!Services.get(IConfigService.class).hasCertificate()) {
            Check.fail(Services.getText(636));
        }
        String uid = Services.get(IConfigService.class).getEdecExportIdentification();
        Date date = new Date();
        Services.get(IEZVService.class).getEvvListExport(test, uid, date, date, true, Role.Zollanmelder, new HashSet<IEZVService.EvvExportListEntry>());
    }

    private ConnectionChecker createBacklogChecker() {
        return new ConnectionChecker(null, this.parent, this.transactionBacklogIconDisplay, () -> {
            if (SafeTransactionReporter.isBacklogCritical()) {
                throw new RuntimeException("Backlog full");
            }
        });
    }

    private IconDisplay createUndecided() {
        return new IconDisplay(IconLoader.getIcon("icon/ConCheckBlack.png"), 0);
    }

    public JButton getOKbutton() {
        return this.OKbutton;
    }

    public String getLicenseKey() {
        return this.getLicenseInfo().getGuidValue();
    }

    public String getCompany() {
        return this.getLicenseInfo().getRegistration().getMainAddress().getCompanyName().getValue();
    }

    private LicenseInfo getLicenseInfo() {
        return Services.get(IConfigService.class).getLicenseInfo();
    }

    public String getCity() {
        return this.getLicenseInfo().getRegistration().getMainAddress().getCity().getValue();
    }

    public Component getDownloadCheck() {
        return this.downloadDisplay;
    }

    public Component getTransSoftCheck() {
        return this.transSoftDisplay;
    }

    public Component getEZVProdCheck() {
        return this.ezvProdDisplay;
    }

    public Component getEZVTestCheck() {
        return this.ezvTestDisplay;
    }

    public Component getTransactionBacklogDisplay() {
        return this.transactionBacklogIconDisplay;
    }
}

