/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.license.gui;

import ch.transsoft.edec.model.config.conf.license.LicenseStateEnum;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.EscapeDialog;
import ch.transsoft.edec.ui.dialog.license.gui.BuyEdecExportPanel;
import ch.transsoft.edec.ui.dialog.license.gui.BuyEvvExportPanel;
import ch.transsoft.edec.ui.dialog.license.gui.BuyEvvImportPanel;
import ch.transsoft.edec.ui.dialog.license.gui.EzvPanel;
import ch.transsoft.edec.ui.dialog.license.gui.RegisterPanel;
import ch.transsoft.edec.ui.dialog.license.gui.RootFolderPanel;
import ch.transsoft.edec.ui.dialog.license.pm.LicenseDialogPm;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.tabs.SimpleTabbedPane;
import ch.transsoft.edec.ui.gui.control.tabs.TabbedPane;
import ch.transsoft.edec.ui.img.IconLoader;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class LicenseDialog
extends EscapeDialog {
    private static final ImageIcon RED = IconLoader.getIcon("icon/license/Point-red-small.png");
    private static final ImageIcon GREEN = IconLoader.getIcon("icon/license/Point-green-small.png");
    private final LicenseDialogPm pm = new LicenseDialogPm();
    private TabbedPane tabbedPane;

    public LicenseDialog() {
        super(Services.getText(4010));
        DialogUtil.centerDialog(this, 900, 760);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new MigLayout("fill", "0[grow, fill]0", "0[44, fill]0[][grow, fill]0"));
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().add(this.createTitle(), "wrap");
        this.getContentPane().add(this.createTestPanel(), "wrap");
        this.getContentPane().add(this.createTabs());
        this.updateState(null);
        this.enableFirstRedTab();
        this.addUpdateStateListener(this.pm);
    }

    private void setTabsEnabled() {
        this.tabbedPane.setEnabledAt(0, true);
        boolean state = this.pm.getRootFolderTabPm().isGreen();
        for (int i2 = 1; i2 < this.tabbedPane.getTabCount(); ++i2) {
            this.tabbedPane.setEnabledAt(i2, state);
        }
    }

    @Override
    protected void handleDispose() {
        this.pm.deployDemoData();
        this.pm.dispose();
    }

    private void addUpdateStateListener(LicenseDialogPm pm) {
        pm.add(new LicenseDialogPm.LicenseDialogListener(){

            @Override
            public void updateState(Integer selection) {
                LicenseDialog.this.updateState(selection);
            }

            @Override
            public void dispose() {
                LicenseDialog.this.dispose();
            }

            @Override
            public void updateConfiguration() {
                LicenseDialog.this.updateConfiguration();
            }
        });
    }

    protected void updateConfiguration() {
        this.pm.getRegisterTabPm().updateConfiguration();
        this.pm.getEzvTabPm().updateConfiguration();
        this.pm.getBuyEdecExportTabPm().updateConfiguration();
        this.pm.getBuyEvvExportTabPm().updateConfiguration();
        this.pm.getBuyEvvImportTabPm().updateConfiguration();
    }

    private void updateState(Integer selection) {
        this.setTabsEnabled();
        this.tabbedPane.setIconAt(0, this.pm.getRootFolderTabPm().isGreen() ? GREEN : RED);
        this.tabbedPane.setIconAt(1, this.pm.getRegisterTabPm().isGreen() ? GREEN : RED);
        this.tabbedPane.setIconAt(2, this.pm.getEzvTabPm().isGreen() ? GREEN : RED);
        this.tabbedPane.setIconAt(3, this.getColor(this.pm.getLicenseInfo().getLicenseStateEdecExportValue()));
        this.tabbedPane.setIconAt(4, this.getColor(this.pm.getLicenseInfo().getLicenseStateEvvExportValue()));
        this.tabbedPane.setIconAt(5, this.getColor(this.pm.getLicenseInfo().getLicenseStateEvvImportValue()));
        if (selection != null) {
            this.tabbedPane.setSelectedIndex(selection);
        }
    }

    private Icon getColor(LicenseStateEnum state) {
        return state == LicenseStateEnum.LICENSED || state == LicenseStateEnum.STUDENT ? GREEN : RED;
    }

    private void enableFirstRedTab() {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.tabbedPane.getIconAt(i2) != RED) continue;
            this.tabbedPane.setSelectedIndex(i2);
            break;
        }
    }

    private Component createTitle() {
        JPanel result = new JPanel();
        result.setBackground(Design.TITLE_BG_COLOR);
        result.setOpaque(true);
        result.setLayout(new MigLayout("fill", "10[][]10", "6[]6"));
        result.add((Component)new JLabel(IconLoader.getIcon(Services.getText(4100))), "push");
        result.add(new JLabel(IconLoader.getIcon("icon/license/transsoft-40x187.png")));
        return result;
    }

    private Component createTestPanel() {
        JPanel result = new JPanel();
        result.setOpaque(false);
        result.setLayout(new MigLayout("fill", "[]", "[]10[]"));
        result.add((Component)this.pm.getTestTitle(), "wrap");
        String text = "<html>" + Services.getText(4045) + "</html>";
        result.add((Component)new Label(text), "");
        return result;
    }

    private Component createTabs() {
        this.tabbedPane = new SimpleTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.tabbedPane.addTab(Services.getText(4022), new RootFolderPanel(this.pm.getRootFolderTabPm()));
        this.tabbedPane.addTab(Services.getText(4023), new RegisterPanel(this.pm.getRegisterTabPm()));
        this.tabbedPane.addTab(Services.getText(4024), new EzvPanel(this.pm.getEzvTabPm()));
        this.tabbedPane.addTab(Services.getText(4025), new BuyEdecExportPanel(this.pm.getBuyEdecExportTabPm()));
        this.tabbedPane.addTab(Services.getText(4180), new BuyEvvExportPanel(this.pm.getBuyEvvExportTabPm()));
        this.tabbedPane.addTab(Services.getText(4113), new BuyEvvImportPanel(this.pm.getBuyEvvImportTabPm()));
        return this.tabbedPane;
    }
}

