/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.license.pm;

import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseStateEnum;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.webservices.LicenseAlreadyBoughtException;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.ui.dialog.license.pm.LicenseDialogPm;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.ErrorUtil;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.openapitools.client.ApiException;

public class BuyEvvImportTabPm
implements IPm {
    private final Label flash = new Label();
    private final JCheckBox acceptAGBs = new JCheckBox();
    private final JButton buyButton = new JButton();
    private final JTextField zazNumber = new JTextField();
    private final JDateChooser startDate = new JDateChooser();
    private final Label label1 = new Label();
    private final Label label2 = new Label();
    private LicenseInfo licenseInfo;
    private final LicenseDialogPm parentPm;
    private Pattern zazPattern = Pattern.compile("\\d+(;\\d+)*");

    public BuyEvvImportTabPm(LicenseDialogPm parentPm) {
        this.parentPm = parentPm;
        this.acceptAGBs.setText(Services.getText(4154));
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.addBuyButtonListener();
        this.updateState();
        this.initFields();
    }

    private void initFields() {
        this.zazNumber.setText(this.licenseInfo.getZazNumber().getValue());
        if (this.licenseInfo.getEvvImportStartDate().isInitialized()) {
            this.startDate.setDate(this.licenseInfo.getEvvImportStartDate().getValue());
        } else {
            this.startDate.setDate(new Date());
        }
        this.flash.setText("");
    }

    public void updateConfiguration() {
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.updateState();
        this.initFields();
    }

    private void updateState() {
        if (this.licenseInfo.getLicenseStateEvvImportValue() == LicenseStateEnum.LICENSED) {
            String text = "<html><h3>" + Services.getText(4060) + "</h3></html>";
            this.label1.setText(text);
            this.buyButton.setEnabled(true);
            this.buyButton.setText(Services.getText(4117));
            this.acceptAGBs.setSelected(true);
            this.acceptAGBs.setEnabled(false);
            return;
        }
        if (this.licenseInfo.getLicenseStateEvvImportValue() == LicenseStateEnum.STUDENT) {
            String text = "<html><h3>" + Services.getText(4062) + "</h3></html>";
            this.label1.setText(text);
            this.buyButton.setEnabled(true);
            this.buyButton.setText(Services.getText(4117));
            this.acceptAGBs.setSelected(true);
            this.acceptAGBs.setEnabled(false);
            return;
        }
        String text = "<html><h3>" + Services.format(4064, 4183) + "</h3></html>";
        this.label1.setText(text);
        this.buyButton.setEnabled(true);
        this.buyButton.setText(Services.getText(4059));
        this.acceptAGBs.setSelected(false);
        this.acceptAGBs.setEnabled(true);
    }

    private void addBuyButtonListener() {
        this.buyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                BuyEvvImportTabPm.this.buttonPressed();
            }
        });
    }

    private void buttonPressed() {
        if (!this.fieldsComplete()) {
            this.setFlashError(Services.getText(4114));
            return;
        }
        if (!this.acceptAGBs.isSelected()) {
            this.setFlashError(Services.getText(4065));
            return;
        }
        this.flash.reset();
        this.flash.setGood("");
        if (this.licenseInfo.getLicenseStateEvvImportValue() == LicenseStateEnum.DEMO) {
            this.buyImportModule();
        } else {
            this.updateUserData();
        }
    }

    private void buyImportModule() {
        if (!this.contactCrmServer(this.licenseInfo.getGuidValue())) {
            return;
        }
        this.licenseInfo.buyLicenseEvvImport(this.getZazNumberUserInput(), this.startDate.getDate());
        Services.get(IConfigService.class).saveLicenseInfo(this.licenseInfo);
        this.updateState();
        this.parentPm.updateState(5);
        String text = "<html><h3>" + Services.getText(4066) + "</h3>" + Services.getText(4067) + "</html>";
        this.label1.setGood(text);
    }

    private void updateUserData() {
        this.licenseInfo.buyLicenseEvvImport(this.getZazNumberUserInput(), this.startDate.getDate());
        Services.get(IConfigService.class).saveLicenseInfo(this.licenseInfo);
        this.updateState();
        this.parentPm.updateState(5);
        this.flash.setGood(Services.getText(4118));
    }

    private String getZazNumberUserInput() {
        return this.zazNumber.getText().trim();
    }

    private void setFlashError(String text) {
        this.flash.setBad("<html><b>" + text + "</b></html>");
    }

    private boolean fieldsComplete() {
        if (!this.zazPattern.matcher(this.getZazNumberUserInput()).matches()) {
            return false;
        }
        return this.startDate.getDate() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contactCrmServer(String guid) {
        try {
            this.parentPm.setHourGlassCursor();
            CustomerManagementFacade.buyLicenseEvvImport(guid);
            boolean bl = true;
            return bl;
        }
        catch (LicenseAlreadyBoughtException e2) {
            this.setFlashError(Services.getText(4068));
            boolean bl = true;
            return bl;
        }
        catch (UnknownGuidException e3) {
            this.setFlashError(Services.getText(4069));
        }
        catch (Exception e4) {
            if (e4.getCause() instanceof ApiException) {
                ErrorUtil.handleConnectionError((ApiException)e4.getCause());
            } else {
                ErrorUtil.log(e4, Services.getText(4070));
            }
        }
        finally {
            this.parentPm.setNormalCursor();
        }
        return false;
    }

    public boolean isGreen() {
        return this.licenseInfo.getLicenseStateEvvImportValue() != LicenseStateEnum.DEMO;
    }

    public Component getFlash() {
        return this.flash;
    }

    public JCheckBox getAcceptAGBs() {
        return this.acceptAGBs;
    }

    public JTextField getZazNumber() {
        return this.zazNumber;
    }

    public JDateChooser getStartDate() {
        return this.startDate;
    }

    public JButton getBuyButton() {
        return this.buyButton;
    }

    public Label getLabel1() {
        return this.label1;
    }

    public Label getLabel2() {
        return this.label2;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }
}

