/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.license.pm;

import ch.transsoft.edec.model.config.conf.license.BillingInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.config.conf.license.RegistrationInfo;
import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.validate.ErrorList;
import ch.transsoft.edec.service.validate.ErrorMarker;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import ch.transsoft.edec.service.webservices.customermgmt.CrmBillingData;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.ui.dialog.license.pm.AddressPm;
import ch.transsoft.edec.ui.dialog.license.pm.ContactPm;
import ch.transsoft.edec.ui.dialog.license.pm.LicenseDialogPm;
import ch.transsoft.edec.ui.gui.control.BooleanField;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.control.combo.SelectionField;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.ErrorUtil;
import ch.transsoft.edec.util.ValidationUtil;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.openapitools.client.ApiException;

public class RegisterTabPm
implements IPm {
    private final Label flash = new Label("", true);
    private final JTextField guid = new JTextField();
    private final SelectionField<DomainValue> language = new SelectionField();
    private final AddressPm addressPm = new AddressPm();
    private final ContactPm contactPm = new ContactPm();
    private final BooleanField electronicBill = new BooleanField("");
    private final StringField billEmail = new StringField();
    private final StringField billEmailCc = new StringField();
    private final StringField invoiceEmail = new StringField();
    private final JButton registerButton;
    private final LicenseDialogPm parentPm;
    private final FieldValidator fieldValidator = new FieldValidator();
    private LicenseInfo licenseInfo;

    public RegisterTabPm(LicenseDialogPm parentPm) {
        this.parentPm = parentPm;
        this.guid.setEditable(false);
        this.registerButton = new JButton();
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.initFields();
        this.updateState();
        this.registerListener();
    }

    public void updateConfiguration() {
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.initFields();
        this.updateState();
    }

    private void updateState() {
        this.flash.reset();
        if (this.isLicensed()) {
            this.guid.setText(this.licenseInfo.getGuid().getValue());
            this.registerButton.setText(Services.getText(4106));
        } else {
            this.guid.setText(Services.getText(4029));
            this.registerButton.setText(Services.getText(4087));
        }
        boolean electronicBillSet = this.electronicBill.isSelected();
        this.billEmail.setReadOnly(!electronicBillSet);
        this.billEmailCc.setReadOnly(!electronicBillSet);
        this.invoiceEmail.setReadOnly(!electronicBillSet);
    }

    private boolean isLicensed() {
        return this.licenseInfo.getGuid().isInitialized();
    }

    private void initFields() {
        this.language.setModel(new SelectionPm(this.licenseInfo.getRegistration().getLanguage()));
        this.guid.setText(this.licenseInfo.getGuidValue());
        this.addressPm.setNode(this.licenseInfo.getRegistration().getMainAddress());
        this.contactPm.setNode(this.licenseInfo.getRegistration().getMainContact());
        BillingInfo billingInfo = this.licenseInfo.getRegistration().getBillingInfo();
        this.electronicBill.setModel(new BooleanPm(billingInfo.getElectronicBill()));
        this.billEmail.setModel(new StringPm(billingInfo.getBillEmail()));
        this.billEmailCc.setModel(new StringPm(billingInfo.getBillEmailCc()));
        this.invoiceEmail.setModel(new StringPm(billingInfo.getInvoiceMail()));
    }

    private void registerListener() {
        this.registerButton.addActionListener(e2 -> this.actionPerformed());
        this.electronicBill.addActionListener(e2 -> this.updateState());
    }

    private void actionPerformed() {
        this.flash.reset();
        if (!this.registrationComplete()) {
            this.flash.setBad(Services.getText(4107));
            return;
        }
        RegistrationInfo info = this.licenseInfo.getRegistration();
        if (this.isLicensed()) {
            this.sendUpdate(this.licenseInfo.getGuid().getValue(), info);
        } else {
            this.sendRegistration(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdate(String guid, RegistrationInfo info) {
        this.saveLicenseInfoToDisk();
        try {
            this.parentPm.setHourGlassCursor();
            CrmBillingData billingData = CustomerManagementFacade.update(guid, info);
            this.licenseInfo.getRegistration().getBillingInfo().set(billingData);
            this.saveLicenseInfoToDisk();
            this.flash.setGood(Services.getText(4108));
        }
        catch (UnknownGuidException e2) {
            this.flash.setBad(Services.getText(4069));
        }
        catch (Exception e3) {
            if (e3.getCause() instanceof ApiException) {
                ErrorUtil.handleConnectionError((ApiException)e3.getCause());
            } else {
                ErrorUtil.log(e3, Services.getText(4089));
            }
        }
        finally {
            this.parentPm.setNormalCursor();
        }
    }

    private void sendRegistration(RegistrationInfo info) {
        String newGuid = this.sendRegistrationToServer(info);
        if (newGuid == null) {
            this.saveLicenseInfoToDisk();
            return;
        }
        this.licenseInfo.getGuid().setValue(newGuid);
        this.saveLicenseInfoToDisk();
        this.flash.setGood(Services.getText(4088));
        this.updateState();
        this.parentPm.updateState(null);
    }

    private String sendRegistrationToServer(RegistrationInfo registration) {
        try {
            this.parentPm.setHourGlassCursor();
            String string = CustomerManagementFacade.register(registration);
            return string;
        }
        catch (Exception e2) {
            if (e2.getCause() instanceof ApiException) {
                ErrorUtil.handleConnectionError((ApiException)e2.getCause());
            } else {
                ErrorUtil.log(e2, Services.getText(4089));
            }
        }
        finally {
            this.parentPm.setNormalCursor();
        }
        return null;
    }

    private void saveLicenseInfoToDisk() {
        Services.get(IConfigService.class).saveLicenseInfo(this.licenseInfo);
    }

    private boolean registrationComplete() {
        return this.fieldValidator.validate(this.licenseInfo.getRegistration());
    }

    public boolean isGreen() {
        return this.isLicensed();
    }

    public Label getFlash() {
        return this.flash;
    }

    public AddressPm getAddressPm() {
        return this.addressPm;
    }

    public ContactPm getContactPm() {
        return this.contactPm;
    }

    public SelectionField<DomainValue> getLanguage() {
        return this.language;
    }

    public JTextField getGuid() {
        return this.guid;
    }

    public JButton getRegisterButton() {
        return this.registerButton;
    }

    public Component getElectronicBill() {
        return this.electronicBill;
    }

    public StringField getBillEmail() {
        return this.billEmail;
    }

    public StringField getBillEmailCc() {
        return this.billEmailCc;
    }

    public StringField getInvoiceEmail() {
        return this.invoiceEmail;
    }

    private static class FieldValidator
    implements ITraversal {
        private ErrorList errorList;

        private FieldValidator() {
        }

        @Override
        public void visit(IPrimitive<?> node) {
            if (node.isMandatory() && !node.isInitialized()) {
                this.errorList.add(new ErrorMarker("notNull", node, Services.getText(948)));
            }
        }

        @Override
        public boolean visitChildren(ModelNode<?> node) {
            return node.isMandatory() || node.isEnabled();
        }

        @Override
        public <T extends ListEntry<T>> void visit(ListNode<T> node) {
        }

        @Override
        public void visit(EnumNode<?> enumNode) {
        }

        public boolean validate(RegistrationInfo registration) {
            if (this.errorList != null) {
                for (ErrorMarker current : this.errorList) {
                    current.getNode().removeError();
                }
            }
            this.errorList = new ErrorList();
            registration.getMainAddress().traverse(this);
            registration.getMainContact().traverse(this);
            BillingInfo billingInfo = registration.getBillingInfo();
            if (billingInfo.getElectronicBill().getValue().booleanValue()) {
                billingInfo.getBillEmail().traverse(this);
                this.validateEmail(billingInfo.getBillEmail());
                this.validateEmail(billingInfo.getBillEmailCc());
                this.validateEmail(billingInfo.getInvoiceMail());
            }
            for (ErrorMarker current : this.errorList) {
                current.getNode().setError(current);
            }
            return this.errorList.isEmpty();
        }

        private void validateEmail(StringNode address) {
            if (!address.isInitialized()) {
                return;
            }
            if (!ValidationUtil.isValidEmailAddress(address.getValue())) {
                this.errorList.add(new ErrorMarker("notNull", address, Services.getText(4185) + address.getValue()));
            }
        }
    }
}

