/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.gui;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.FileSystemAttachment;
import ch.transsoft.edec.ui.dialog.mail.pm.AttachmentModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class FileTransferHandler
extends TransferHandler {
    private final AttachmentModel attachmentModel;

    public FileTransferHandler(AttachmentModel attachmentModel) {
        this.attachmentModel = attachmentModel;
    }

    @Override
    public boolean canImport(JComponent arg0, DataFlavor[] arg1) {
        for (int i2 = 0; i2 < arg1.length; ++i2) {
            DataFlavor flavor = arg1[i2];
            if (!flavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        try {
            return this.handleData(t);
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean handleData(Transferable t) throws UnsupportedFlavorException, IOException {
        DataFlavor[] flavors = t.getTransferDataFlavors();
        for (int i2 = 0; i2 < flavors.length; ++i2) {
            DataFlavor flavor = flavors[i2];
            if (!flavor.equals(DataFlavor.javaFileListFlavor)) continue;
            for (File f2 : (List)t.getTransferData(DataFlavor.javaFileListFlavor)) {
                AttachmentEntry entry = NodeFactory.create(AttachmentEntry.class);
                entry.getAttachmentHandle().setBody(new FileSystemAttachment(f2, null, false));
                this.attachmentModel.addEntry(entry);
            }
            return true;
        }
        return false;
    }
}

