/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.EscapeDialog;
import ch.transsoft.edec.ui.dialog.mail.gui.MailHeadPanel;
import ch.transsoft.edec.ui.dialog.mail.gui.MailPanel;
import ch.transsoft.edec.ui.dialog.mail.pm.IMailDialogPm;
import ch.transsoft.edec.ui.dialog.option.gui.OptionDialog;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.LinkLabel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.miginfocom.swing.MigLayout;

public class MailDialog
extends EscapeDialog {
    private final IMailDialogPm pm;

    public MailDialog(IMailDialogPm pm) {
        super(pm.getTitle());
        this.pm = pm;
        DialogUtil.centerDialog(this, 900, 760);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)new MailHeadPanel(pm.getFlash(), pm), "North");
        this.getContentPane().add(new MailPanel(pm));
        this.getContentPane().add(this.createControls(), "South");
        this.addSendButtonListener();
    }

    private void addSendButtonListener() {
        this.pm.getSendButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (MailDialog.this.pm.isAddressesMissing()) {
                    DialogUtil.showWarningDialog(Services.getText(630), Services.getText(631));
                    return;
                }
                String invalid = MailDialog.this.pm.getInvalidEmailAddress();
                if (invalid != null) {
                    DialogUtil.showWarningDialog(Services.getText(630), Services.getText(632) + " " + invalid);
                    return;
                }
                try {
                    MailDialog.this.pm.sendMail();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                MailDialog.this.dispose();
            }
        });
    }

    private Component createControls() {
        DefaultPanel result = new DefaultPanel();
        result.setLayout(new MigLayout("fillx", "push[][]"));
        if (this.pm.isSendViaTransSoftServer()) {
            this.addMailInfoLinkLabel(result);
        }
        result.add((Component)this.pm.getSendButton(), "sg");
        result.add(this.createCancelButton(), "sg");
        return result;
    }

    private void addMailInfoLinkLabel(DefaultPanel result) {
        LinkLabel link = new LinkLabel("<html><b><font color='red'>" + Services.getText(4157) + "</font> <a href=config> " + Services.getText(4158) + "</a>&nbsp;&nbsp;<b></html> ");
        link.addLinkListener("config", () -> {
            this.dispose();
            Services.get(IConfigService.class).reloadConfiguration();
            OptionDialog dialog = new OptionDialog();
            dialog.showMail();
            dialog.setVisible(true);
        });
        result.add(link);
    }

    private Component createCancelButton() {
        JButton result = new JButton(Services.getText(208));
        result.addActionListener(e2 -> this.dispose());
        return result;
    }
}

