/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.model;

import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.render.DataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import ch.transsoft.edec.ui.dialog.print.pm.IPagePrintJob;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.pdf.PdfUtil;
import java.io.File;
import java.util.List;
import javax.swing.ImageIcon;

public class FormAttachment
implements IAttachmentBody {
    private final Sending backgroundSending;
    private final IFormDesc form;
    private final String filename;

    public FormAttachment(Sending sending, IFormDesc form, String filename) {
        this.filename = filename;
        this.backgroundSending = sending.getCopy((ModelNode)null);
        this.form = form;
    }

    @Override
    public byte[] getData(Object context) throws Exception {
        DataContext dataContext = this.form.createDataContext(this.backgroundSending);
        List<IPagePrintJob> jobs = this.form.printPage(this.backgroundSending, dataContext, this.form.getFrontPage(this.backgroundSending), IRenderContext.Mode.mail);
        if (this.form.hasBackPage()) {
            jobs.addAll(this.form.printPage(this.backgroundSending, dataContext, this.form.getBackPage(), IRenderContext.Mode.mail));
        }
        return PdfUtil.createPdf(jobs);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getMimeType() {
        return "application/pdf";
    }

    @Override
    public boolean supportPreview() {
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/pdf-small.png");
    }

    @Override
    public void showDocument() {
        try {
            Services.get(IGuiService.class).setHourGlassCursor(true);
            DocumentUtil.showPdf(this.getData(null), this.form.getId().name());
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(4210));
        }
        finally {
            Services.get(IGuiService.class).setHourGlassCursor(false);
        }
    }

    @Override
    public void copyToFolder(File folder) {
    }
}

