/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.model;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import javax.swing.Icon;

public class ReceiptImportAttachment
implements IAttachmentBody {
    private final ReceiptDocumentType type;
    private final ReceiptDocumentFlavour flavour;
    private final ReceiptEntry entry;

    public ReceiptImportAttachment(ReceiptEntry entry, ReceiptDocumentType type, ReceiptDocumentFlavour flavour) {
        this.entry = entry;
        this.type = type;
        this.flavour = flavour;
    }

    @Override
    public byte[] getData(Object context) throws Exception {
        ImportSending sending = (ImportSending)context;
        ReceiptDocument doc = sending.getReceiptDocument(this.type);
        switch (this.flavour) {
            case xml: {
                return doc.getData().getByteArray();
            }
            case pdf: {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PdfWriter.createReceipt(new ByteArrayInputStream(doc.getData().getByteArray()), (OutputStream)out);
                return out.toByteArray();
            }
            case txt: {
                return doc.getValidationProtocol().getByteArray();
            }
        }
        throw Check.fail("Unexpected flavour: " + this.flavour);
    }

    @Override
    public String getFileName() {
        return this.entry.getCustomsReferenceNumberStr() + "_" + this.type + "." + this.flavour;
    }

    @Override
    public Icon getIcon() {
        switch (this.flavour) {
            case xml: {
                return IconLoader.getIcon("icon/xml-small.png");
            }
            case pdf: {
                return IconLoader.getIcon("icon/pdf-small.png");
            }
            case txt: {
                return IconLoader.getIcon("icon/txt-small.png");
            }
        }
        throw Check.fail("Unexpected flavour: " + this.flavour);
    }

    @Override
    public String getMimeType() {
        return "application/file";
    }

    @Override
    public void showDocument() {
        switch (this.flavour) {
            case pdf: {
                DocumentUtil.showReceipt(this.entry, this.type);
            }
            case xml: 
            case txt: {
                return;
            }
        }
        throw Check.fail("Unexpected flavour: " + this.flavour);
    }

    @Override
    public boolean supportPreview() {
        switch (this.flavour) {
            case pdf: {
                return true;
            }
            case xml: 
            case txt: {
                return false;
            }
        }
        throw Check.fail("Unexpected flavour: " + this.flavour);
    }

    @Override
    public void copyToFolder(File folder) {
    }

    public static enum ReceiptDocumentFlavour {
        xml,
        pdf,
        txt;

    }
}

