/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.pm;

import ch.transsoft.edec.model.config.conf.mail.MailInfo;
import ch.transsoft.edec.model.config.conf.mail.MailText;
import ch.transsoft.edec.model.config.conf.options.MailOptionInfo;
import ch.transsoft.edec.model.config.pref.mail.MailPreferenceInfo;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.masterdata.Addresses;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.SendMailToImporteurJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.SendMailToImporteurViaOutlookJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.SendMailToImporteurViaSmtpJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.insert.IInsertDialogTrait;
import ch.transsoft.edec.ui.dialog.insert.InsertDialog;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.ReceiptImportAttachment;
import ch.transsoft.edec.ui.dialog.mail.pm.AttachmentModel;
import ch.transsoft.edec.ui.dialog.mail.pm.MailDialogPmBase;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.AddButton;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.util.TextUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MailDialogImportPm
extends MailDialogPmBase {
    private final ReceiptEntry entry;
    private final MailOptionInfo mailOptionInfo;
    private final MailPreferenceInfo mailPreferenceInfo;
    private final AttachmentModel attachmentModel;
    private final JButton sendButton;
    private final JCheckBox sendCopy;
    private final JTextField toAddress;
    private final JTextField fromAddress;
    private final JTextArea content;
    private final JTextField subject;
    private final JScrollPane contentScrollPane;
    private final ListNode<AttachmentEntry> attachments;
    private ActionBase newAction;
    private ActionBase deleteAction;
    private ActionBase saveAction;
    private JComboBox<MailText> textSelectionCombo;
    private final Label flash = new Label(" ", true);
    private final MailInfo mailInfo;
    private final AddButton addButton;

    public MailDialogImportPm(ReceiptEntry entry) {
        this.entry = entry;
        this.mailInfo = Services.get(IConfigService.class).getReceiptImportMailInfo();
        this.mailOptionInfo = Services.get(IConfigService.class).getOptionInfo().getMailOptionInfo();
        this.mailPreferenceInfo = Services.get(IConfigService.class).getPreferences().getMailPreferenceInfo();
        this.attachments = new ListNode<AttachmentEntry>(AttachmentEntry.class);
        if (entry.hasRbm()) {
            this.addAttachment(ReceiptDocumentType.rbm);
        }
        if (entry.hasRbz()) {
            this.addAttachment(ReceiptDocumentType.rbz);
        }
        if (entry.hasVvm()) {
            this.addAttachment(ReceiptDocumentType.vvm);
        }
        if (entry.hasVvz()) {
            this.addAttachment(ReceiptDocumentType.vvz);
        }
        this.attachmentModel = new AttachmentModel(this.attachments, this.flash);
        this.content = new JTextArea();
        this.contentScrollPane = new JScrollPane(this.content);
        this.subject = new JTextField();
        this.sendButton = new JButton(this.getSendMailText());
        this.sendCopy = new JCheckBox(Services.getText(4217));
        this.sendCopy.setSelected(this.mailInfo.getSendCopyToConsignor().getValue());
        this.addSendCopyListener();
        this.toAddress = new JTextField();
        this.toAddress.setBackground(Design.CONTROL_BG_MANDATORY);
        this.fromAddress = new JTextField();
        this.fromAddress.setBackground(Design.CONTROL_BG_MANDATORY);
        this.toAddress.setText("");
        this.fromAddress.setText(this.getDefaultFromAddress());
        this.addButton = new AddButton();
        this.addButton.setFocusable(true);
        this.addButton.setToolTipText(Services.getText(4248));
        this.addAddButtonListener();
        this.createActions();
        this.updateDeleteActionEnablement();
        this.createTextSelectionCombo();
    }

    private String getDefaultFromAddress() {
        if (this.mailPreferenceInfo.getSendViaOutlook()) {
            return "";
        }
        if (this.mailPreferenceInfo.getSendViaTransSoftServer()) {
            return this.mailInfo.getLastFromAddress().getValue();
        }
        if (this.mailPreferenceInfo.getSendViaSMTP()) {
            return this.mailPreferenceInfo.getSenderEmailAdress().getValue();
        }
        throw new IllegalStateException("Unexpected Mail Strategy");
    }

    private void addAddButtonListener() {
        this.addButton.addActionListener(e2 -> {
            IInsertDialogTrait trait = Addresses::getAddresses;
            InsertDialog<Address, Addresses> dialog = new InsertDialog<Address, Addresses>(Services.getText(1110), this.addButton, trait, DataFiles.address, Address.tableConfig, t -> {
                if (!this.toAddress.getText().isEmpty()) {
                    this.toAddress.setText(this.toAddress.getText() + ";");
                }
                this.toAddress.setText(this.toAddress.getText() + t.getEmail().getValue());
            });
            dialog.setVisible(true);
        });
    }

    private void addAttachment(ReceiptDocumentType type) {
        this.addAttachment(type, ReceiptImportAttachment.ReceiptDocumentFlavour.xml);
        this.addAttachment(type, ReceiptImportAttachment.ReceiptDocumentFlavour.pdf);
        this.addAttachment(type, ReceiptImportAttachment.ReceiptDocumentFlavour.txt);
    }

    private void addAttachment(ReceiptDocumentType type, ReceiptImportAttachment.ReceiptDocumentFlavour flavour) {
        AttachmentEntry attachment = NodeFactory.create(AttachmentEntry.class);
        attachment.getAttachmentHandle().setBody(new ReceiptImportAttachment(this.entry, type, flavour));
        this.attachments.add(attachment);
    }

    private void addSendCopyListener() {
        this.sendCopy.addActionListener(e2 -> {
            this.mailInfo.getSendCopyToConsignor().setValue(this.sendCopy.isSelected());
            this.saveActionPerformed();
        });
    }

    private void createTextSelectionCombo() {
        this.textSelectionCombo = new JComboBox();
        if (this.mailInfo.getMailTexts().isEmpty()) {
            this.mailInfo.getMailTexts().add(this.createDefaultMailText());
        } else {
            for (MailText current : this.mailInfo.getMailTexts()) {
                if (current.getSubject().isInitialized()) continue;
                current.getSubject().setValue(this.getSubjectText());
            }
        }
        String lastSelection = this.mailInfo.getLastSelectedMailText().getValue();
        for (MailText current : this.mailInfo.getMailTexts()) {
            this.textSelectionCombo.addItem(current);
            if (!current.getName().getValue().equals(lastSelection)) continue;
            this.textSelectionCombo.setSelectedItem(current);
        }
        this.setTextToTextArea();
        this.addComboListener();
    }

    private void addComboListener() {
        this.textSelectionCombo.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                MailDialogImportPm.this.handleContentsChanged();
            }
        });
    }

    private void handleContentsChanged() {
        this.setTextToTextArea();
        this.mailInfo.getLastSelectedMailText().setValue(this.getSelectedText().getName().getValue());
        this.saveMailInfo();
    }

    private void saveMailInfo() {
        Services.get(IConfigService.class).saveReceiptImportMailInfo(this.mailInfo);
    }

    private void setTextToTextArea() {
        this.content.setText(this.getSelectedText().getText().getValue());
        this.content.setCaretPosition(0);
        this.subject.setText(this.getSelectedText().getSubject().getValue());
    }

    private MailText createDefaultMailText() {
        MailText result = NodeFactory.create(MailText.class);
        result.getName().setValue(this.getTitleText());
        result.getText().setValue(this.getContentText());
        result.getSubject().setValue(this.getSubjectText());
        return result;
    }

    private String getTitleText() {
        return Services.getText(4247);
    }

    private String getContentText() {
        StringBuilder result = new StringBuilder();
        result.append(Services.getText(3054));
        result.append("\n");
        result.append("\n");
        result.append(Services.getText(3055));
        result.append("\n");
        result.append("\n");
        result.append(Services.getText(3056));
        result.append("\n");
        result.append("\n");
        result.append(Services.getText(3057));
        result.append("\n");
        result.append(Services.getText(3058));
        result.append("\n");
        result.append(Services.getText(3059));
        result.append("\n");
        result.append(Services.getText(3060));
        result.append("\n");
        result.append("\n");
        result.append(Services.getText(3062));
        return result.toString();
    }

    private String getSubjectText() {
        return Services.getText(785);
    }

    private void createActions() {
        this.newAction = new ActionBase(Services.getText(4219), "icon/New-small.png", "icon/New-small.png"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MailDialogImportPm.this.newActionPerformed();
            }
        };
        this.newAction.setTooltip(Services.getText(4220));
        this.deleteAction = new ActionBase(Services.getText(4221), "icon/Delete-small.png", "icon/Delete-small.png"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MailDialogImportPm.this.deleteActionPerformed();
            }
        };
        this.deleteAction.setTooltip(Services.getText(4222));
        this.saveAction = new ActionBase(Services.getText(4223), "icon/Save-small.png", "icon/Save-small.png"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MailDialogImportPm.this.saveActionPerformed();
            }
        };
        this.saveAction.setTooltip(Services.getText(4224));
    }

    protected void saveActionPerformed() {
        MailText text = this.getSelectedText();
        text.getText().setValue(this.content.getText());
        text.getSubject().setValue(this.subject.getText());
        this.saveMailInfo();
    }

    private MailText getSelectedText() {
        return (MailText)this.textSelectionCombo.getSelectedItem();
    }

    protected void deleteActionPerformed() {
        MailText text = this.getSelectedText();
        this.mailInfo.getMailTexts().remove(text);
        this.textSelectionCombo.removeItem(text);
        this.updateDeleteActionEnablement();
    }

    private void updateDeleteActionEnablement() {
        this.deleteAction.setEnabled(this.mailInfo.getMailTexts().size() > 1);
    }

    protected void newActionPerformed() {
        String name = DialogUtil.getInput(Services.getText(4225), Services.getText(4226));
        if (name == null) {
            return;
        }
        MailText text = NodeFactory.create(MailText.class);
        text.getName().setValue(name);
        this.mailInfo.getMailTexts().add(text);
        this.textSelectionCombo.addItem(text);
        this.textSelectionCombo.setSelectedItem(text);
        this.updateDeleteActionEnablement();
    }

    @Override
    public JCheckBox getSendCopy() {
        return this.sendCopy;
    }

    @Override
    public JTextField getToAddressField() {
        return this.toAddress;
    }

    @Override
    public List<String> getToAddress() {
        String noSpaces = this.toAddress.getText().replaceAll(" ", "");
        if (noSpaces.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] addresses = noSpaces.split(";");
        return Arrays.asList(addresses);
    }

    @Override
    public JTextField getFromAddressField() {
        return this.fromAddress;
    }

    @Override
    public String getFromAddress() {
        return this.fromAddress.getText().replaceAll(" ", "");
    }

    @Override
    public AttachmentModel getAttachmentModel() {
        return this.attachmentModel;
    }

    @Override
    public JButton getSendButton() {
        return this.sendButton;
    }

    @Override
    public ListNode<AttachmentEntry> getAttachments() {
        return this.attachments;
    }

    @Override
    public JComponent getContent() {
        return this.contentScrollPane;
    }

    @Override
    public JComponent getSubject() {
        return this.subject;
    }

    @Override
    public CarrierMail getMail() {
        CarrierMail result = new CarrierMail();
        result.getToAddresses().addAll(this.getToAddress());
        if (this.sendCopy.isSelected()) {
            result.getCcAddresses().add(this.getFromAddress());
        }
        result.setReplyAddress(this.getFromAddress());
        if (Services.get(IConfigService.class).getOptionInfo().getMailOptionInfo().getConsignorAsFromAddr().getValue().booleanValue()) {
            result.setFromAddress(this.getFromAddress());
        } else {
            result.setFromAddress("expovit@transsoft.ch");
        }
        result.setSubject(TextUtil.resolveFields(this.entry, this.subject.getText()));
        result.setContent(TextUtil.resolveFields(this.entry, this.content.getText()));
        return result;
    }

    @Override
    public void sendMail() {
        this.mailInfo.getLastFromAddress().setValue(this.getFromAddress());
        this.saveMailInfo();
        if (this.isSendViaOutlook()) {
            Services.get(IBackendService.class).put(new SendMailToImporteurViaOutlookJob(this.entry, this.getMail(), this.getAttachments()));
        } else if (this.isSendViaSMTP()) {
            Services.get(IBackendService.class).put(new SendMailToImporteurViaSmtpJob(this.entry, this.getMail(), this.getAttachments()));
        } else {
            Services.get(IBackendService.class).put(new SendMailToImporteurJob(this.entry, this.getMail(), this.getAttachments()));
        }
    }

    @Override
    public JComboBox<MailText> getTextSelectionCombo() {
        return this.textSelectionCombo;
    }

    @Override
    public Action getNewAction() {
        return this.newAction;
    }

    @Override
    public Action getDeleteAction() {
        return this.deleteAction;
    }

    @Override
    public Action getSaveAction() {
        return this.saveAction;
    }

    @Override
    public Label getFlash() {
        return this.flash;
    }

    @Override
    public String getHeaderText() {
        return Services.getText(4246);
    }

    @Override
    public String getIcon() {
        return "icon/mail128-128.png";
    }

    @Override
    public String getTitle() {
        return Services.getText(4247);
    }

    @Override
    public JComponent getAddButton() {
        return this.addButton;
    }
}

