/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.pm;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.mail.pm.IMailDialogPm;

public abstract class MailDialogPmBase
implements IMailDialogPm {
    @Override
    public boolean isSendViaOutlook() {
        return Services.get(IConfigService.class).getPreferences().getMailPreferenceInfo().getSendViaOutlook();
    }

    @Override
    public boolean isSendViaSMTP() {
        return Services.get(IConfigService.class).getPreferences().getMailPreferenceInfo().getSendViaSMTP();
    }

    @Override
    public boolean isSendViaTransSoftServer() {
        return Services.get(IConfigService.class).getPreferences().getMailPreferenceInfo().getSendViaTransSoftServer();
    }

    protected String getSendMailText() {
        return Services.getText(4216);
    }

    @Override
    public String getInvalidEmailAddress() {
        for (String current : this.getToAddress()) {
            if (this.isValid(current)) continue;
            return current;
        }
        if (this.isSendViaTransSoftServer() && !this.isValid(this.getFromAddress())) {
            return this.getFromAddress();
        }
        return null;
    }

    @Override
    public boolean isAddressesMissing() {
        if (this.getToAddress().isEmpty()) {
            return true;
        }
        if (this.isSendViaOutlook()) {
            return false;
        }
        if (this.isSendViaSMTP()) {
            return false;
        }
        if (this.isSendViaSMTP()) {
            return false;
        }
        return this.getFromAddress().isEmpty();
    }

    private boolean isValid(String address) {
        return mailPattern.matcher(address).matches();
    }
}

