/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.masterdata;

import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.dialog.masterdata.IMasterdataPm;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ReflectionUtil;
import java.awt.BorderLayout;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class DetailPanelContainer<E extends ListEntry<E>>
extends DefaultPanel
implements TablePm.ISelectionListener<E> {
    private final Class<? extends IMasterdataPm> pmType;
    private final Class<? extends JComponent> guiType;
    private IMasterdataPm currentPm;
    private JComponent gui;

    public DetailPanelContainer(Class<? extends IMasterdataPm> pmType, Class<? extends JComponent> guiType) {
        this.pmType = pmType;
        this.guiType = guiType;
        this.setLayout(new BorderLayout());
        try {
            this.gui = guiType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
        this.add(this.gui);
    }

    @Override
    public void selectionChanged(E current, boolean isEmptyLine, boolean sameItem) {
        if (sameItem) {
            return;
        }
        Services.get(IGuiService.class).commitCurrentEditor();
        this.changeContent(current);
    }

    private void changeContent(E current) {
        try {
            if (this.currentPm != null) {
                ReflectionUtil.recursiveDispose(this.currentPm);
            }
            this.currentPm = this.pmType.getConstructor(current.getClass()).newInstance(current);
            Method setModel = this.guiType.getMethod("setModel", this.pmType);
            setModel.invoke((Object)this.gui, this.currentPm);
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    public void dispose() {
        if (this.currentPm != null) {
            ReflectionUtil.recursiveDispose(this.currentPm);
        }
    }

    public void saveChanges() {
        this.currentPm.saveChanges();
    }
}

