/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.masterdata;

import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.masterdata.DataNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.masterdata.IDataFile;
import ch.transsoft.edec.service.masterdata.IDataListener;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.ui.dialog.masterdata.IMasterdataPm;
import ch.transsoft.edec.ui.dialog.masterdata.MasterDataDialog;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.disposable.IDisposable;
import javax.swing.JComponent;

public abstract class DialogBase<T extends DataNode<T>, E extends ListEntry<E>> {
    private final MasterDataDialog<T, E> dialog;
    private final IDisposable disposable;

    public DialogBase(String name, Class<? extends IMasterdataPm> pmType, Class<? extends JComponent> guiType, IDataFile<T> dataFile, boolean doValidation) {
        this.disposable = this.getDataService().addDataListener(dataFile, this.createDataListener());
        this.getDataService().loadData(dataFile, true);
        this.dialog = new MasterDataDialog(name, pmType, guiType, doValidation);
    }

    private IDataListener<T> createDataListener() {
        return data -> {
            this.dialog.setModel(data, this.createTablePm(data));
            this.disposable.dispose();
        };
    }

    public abstract TablePm<E> createTablePm(T var1);

    private IDataService getDataService() {
        return Services.get(IDataService.class);
    }

    public void show() {
        try {
            this.dialog.setVisible(true);
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, "Failed to open dialog. Retry.");
        }
    }
}

