/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.masterdata;

import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.masterdata.DataNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.EscapeDialog;
import ch.transsoft.edec.ui.dialog.masterdata.ContentPanel;
import ch.transsoft.edec.ui.dialog.masterdata.IMasterdataPm;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.pm.model.TablePm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.miginfocom.swing.MigLayout;

public class MasterDataDialog<T extends DataNode<T>, E extends ListEntry<E>>
extends EscapeDialog {
    private ContentPanel<T, E> contentPanel;
    private final Class<? extends IMasterdataPm> pmType;
    private final Class<? extends JComponent> guiType;
    private T masterData;

    public MasterDataDialog(String name, Class<? extends IMasterdataPm> pmType, Class<? extends JComponent> guiType, boolean doValidation) {
        super(String.format(Services.getText(4310), name));
        this.pmType = pmType;
        this.guiType = guiType;
        this.getContentPane().setLayout(new BorderLayout());
        DialogUtil.centerDialog(this, 1124, 650);
        this.getContentPane().add(this.createLabel(), "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                Services.get(IGuiService.class).commitCurrentEditor();
                MasterDataDialog.this.requestExit();
            }

            @Override
            public void windowClosed(WindowEvent e2) {
                if (MasterDataDialog.this.contentPanel != null) {
                    MasterDataDialog.this.contentPanel.dispose();
                }
                MasterDataDialog.this.contentPanel = null;
            }
        });
    }

    private Component createLabel() {
        Label result = new Label(Services.getText(4311));
        result.setHorizontalAlignment(0);
        return result;
    }

    public void setModel(T masterData, TablePm<E> pm) {
        this.masterData = masterData;
        this.contentPanel = new ContentPanel<T, E>(pm, masterData, this.pmType, this.guiType);
        this.getContentPane().removeAll();
        this.getContentPane().add(this.contentPanel, "Center");
        this.getContentPane().add(this.createControls(), "South");
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    private Component createControls() {
        DefaultPanel result = new DefaultPanel();
        result.setLayout(new MigLayout("fillx", "push[][]"));
        result.add(this.createSaveButton(), "sg");
        result.add(this.createCancelButton(), "sg");
        return result;
    }

    private Component createCancelButton() {
        JButton result = new JButton(Services.getText(209));
        result.addActionListener(e2 -> this.requestExit());
        return result;
    }

    @Override
    protected void processEscPressed() {
        this.requestExit();
    }

    private void requestExit() {
        if (this.contentPanel == null || this.contentPanel.noPendingChanges()) {
            this.dispose();
            return;
        }
        switch (DialogUtil.showSaveDialogt(this, Services.getText(204), Services.getText(203))) {
            case 0: {
                this.saveChanges();
                this.dispose();
                break;
            }
            case 1: {
                this.dispose();
                break;
            }
        }
    }

    private Component createSaveButton() {
        JButton result = new JButton(Services.getText(201));
        result.addActionListener(e2 -> this.saveChanges());
        return result;
    }

    private void saveChanges() {
        this.contentPanel.saveChanges();
    }
}

