/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.masterdata.declarant;

import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.sending.goodsdeclaration.Declarant;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.masterdata.IMasterdataPm;
import ch.transsoft.edec.ui.pm.model.IntegralPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.Check;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DeclarantDetailPm
implements IMasterdataPm {
    private final IntegralPm id;
    private final StringPm declarantName;
    private final StringPm companyName;
    private final StringPm street;
    private final StringPm postalCode;
    private final StringPm city;
    private final SelectionPm country;
    private final StringPm email;
    private final StringPm phone;
    private LicenseInfo licenseInfo;
    private final PlainDocument zkvLogin2;
    private final PlainDocument zkvLogin3;

    public DeclarantDetailPm(Declarant declarant) {
        this.id = new IntegralPm(declarant.getDeclarantNumber());
        this.declarantName = new StringPm(declarant.getDeclarantName());
        this.companyName = new StringPm(declarant.getCompanyName());
        this.street = new StringPm(declarant.getStreet());
        this.postalCode = new StringPm(declarant.getPostalCode());
        this.city = new StringPm(declarant.getCity());
        this.country = new SelectionPm(declarant.getCountry());
        this.email = new StringPm(declarant.getEmail());
        this.phone = new StringPm(declarant.getPhone());
        this.zkvLogin2 = new PlainDocument();
        this.zkvLogin3 = new PlainDocument();
        this.readLoginInfo();
    }

    private void readLoginInfo() {
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        try {
            this.zkvLogin2.insertString(0, this.licenseInfo.getCertificate().getZkvLogin2().getValue(), null);
            this.zkvLogin3.insertString(0, this.licenseInfo.getCertificate().getZkvLogin3().getValue(), null);
        }
        catch (BadLocationException e2) {
            Check.fail(e2);
        }
    }

    private void writeLoginInfo() {
        try {
            this.licenseInfo.getCertificate().getZkvLogin2().setValue(this.zkvLogin2.getText(0, this.zkvLogin2.getLength()));
            this.licenseInfo.getCertificate().getZkvLogin3().setValue(this.zkvLogin3.getText(0, this.zkvLogin3.getLength()));
            Services.get(IConfigService.class).saveLicenseInfo(this.licenseInfo);
        }
        catch (BadLocationException e2) {
            Check.fail(e2);
        }
    }

    public StringPm getStreet() {
        return this.street;
    }

    public StringPm getPostalCode() {
        return this.postalCode;
    }

    public StringPm getCity() {
        return this.city;
    }

    public SelectionPm getCountry() {
        return this.country;
    }

    public IntegralPm getId() {
        return this.id;
    }

    public StringPm getDeclarantName() {
        return this.declarantName;
    }

    public StringPm getCompanyName() {
        return this.companyName;
    }

    public StringPm getEmail() {
        return this.email;
    }

    public StringPm getPhone() {
        return this.phone;
    }

    public Document getZkvLogin2Doc() {
        return this.zkvLogin2;
    }

    public Document getZkvLogin3Doc() {
        return this.zkvLogin3;
    }

    @Override
    public void saveChanges() {
        this.writeLoginInfo();
    }
}

