/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.print.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.print.pm.PrintDialogPm;
import ch.transsoft.edec.ui.dialog.print.pm.PrintJobPm;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.LabelField;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplay;
import ch.transsoft.edec.ui.gui.control.textfield.TextField;
import java.awt.Component;
import javax.swing.JCheckBox;
import net.miginfocom.swing.MigLayout;

public class PrintPanel
extends DefaultPanel {
    public PrintPanel(PrintDialogPm pm) {
        this.setLayout(new MigLayout("", "[][]10[]10[]50[]10[100, fill][]0[]"));
        this.addHeaders();
        for (PrintJobPm current : pm.getPrintJobPms()) {
            this.addControls(current);
        }
    }

    private void addHeaders() {
        this.add((Component)new Label(Services.getText(4503), true), "span 2");
        this.add(new Label(Services.getText(4504), true));
        this.add(new Label(Services.getText(4505), true));
        this.add(new Label(Services.getText(4506), true));
        this.add((Component)new Label(Services.getText(4507), true), "span 3, wrap");
    }

    private void addControls(PrintJobPm pm) {
        IconDisplay iconDisplay = new IconDisplay(pm.getIcon());
        this.add((Component)iconDisplay, "width 40!, height 40!");
        this.add(new Label(pm.getFormName()));
        JCheckBox print = new JCheckBox();
        print.setModel(pm.getPrintModel());
        this.add(print);
        this.add((Component)new TextField(pm.getNumberModel()), "width 50!");
        this.add(new Label(pm.getPrinter()));
        this.add(new LabelField(pm.getNumberOfUnitsModel(), false));
        this.add((Component)new IconDisplay(pm.getBatchIconModel()), "width 34!, height 40!");
        this.add((Component)new IconDisplay(pm.getArrowIconModel()), "width 28!, height 28!, wrap");
    }
}

