/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.printerconfig.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.printer.Printer;
import ch.transsoft.edec.ui.dialog.printerconfig.gui.PrinterSelectionHeadPanel;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.FormConfigPm;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.FormPageConfigPm;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.IPrinterConfigListener;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.PrinterConfigPm;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.combo.StateAwareComboBox;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.print.attribute.standard.MediaTray;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class PrinterSelectionPanel
extends DefaultPanel {
    private final PrinterConfigPm pm;
    private final PrinterSelectionHeadPanel headPanel;

    public PrinterSelectionPanel(PrinterConfigPm pm) {
        this.pm = pm;
        this.setLayout(new BorderLayout());
        this.addPmListener();
        this.headPanel = this.createHeader();
        this.add((Component)this.headPanel, "North");
        this.add((Component)new JScrollPane(this.createContent()), "Center");
    }

    private void addPmListener() {
        this.pm.addListener(new IPrinterConfigListener(){

            @Override
            public void finish() {
                PrinterSelectionPanel.this.headPanel.printersLoaded();
            }

            @Override
            public void next(Printer printer) {
                PrinterSelectionPanel.this.headPanel.next(printer);
            }
        });
    }

    private JComponent createContent() {
        DefaultPanel contentPanel = new DefaultPanel();
        contentPanel.setLayout(new MigLayout("", "[][]20[fill, 300::500]10[fill, 200::400]20[]", ""));
        contentPanel.add((Component)new Label(Services.getText(4610), true), "span 2");
        contentPanel.add(new Label(Services.getText(4611), true));
        contentPanel.add(new Label(Services.getText(4612), true));
        contentPanel.add((Component)new Label(Services.getText(4613), true), "wrap");
        for (FormConfigPm formConfigPm : this.pm.getFormConfigPms()) {
            this.createContent(contentPanel, formConfigPm);
        }
        return contentPanel;
    }

    private void createContent(DefaultPanel contentPanel, FormConfigPm formConfigPm) {
        FormPageConfigPm front = formConfigPm.getFrontPm();
        FormPageConfigPm back = formConfigPm.getBackPm();
        this.addFormPageControls(contentPanel, front, back == null, front.getPrintName());
        if (back == null) {
            return;
        }
        this.addDuplexCheckbox(contentPanel, formConfigPm);
        this.addFormPageControls(contentPanel, back, true, back.getPrintName());
    }

    private void addFormPageControls(DefaultPanel panel, FormPageConfigPm page, boolean wrap, String name) {
        IconDisplay iconDisplay = new IconDisplay(page.getIcon());
        panel.add((Component)iconDisplay, "width 40!, height 40!");
        panel.add(new Label(name));
        panel.add(new StateAwareComboBox<Printer>(page.getPrinterModel()));
        panel.add(new StateAwareComboBox<MediaTray>(page.getTrayModel()), wrap ? "wrap" : "");
    }

    private void addDuplexCheckbox(DefaultPanel contentPanel, FormConfigPm pm) {
        JCheckBox duplex = new JCheckBox();
        contentPanel.add((Component)duplex, "wrap");
        duplex.setModel(pm.getDuplexModel());
    }

    private PrinterSelectionHeadPanel createHeader() {
        return new PrinterSelectionHeadPanel(this.pm);
    }
}

