/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.printerconfig.pm;

import ch.transsoft.edec.model.config.conf.printer.PrintNameCorrection;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.util.DocumentListenerAdapter;
import ch.transsoft.edec.util.StringNodeDocumentListener;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;

public final class PrinterNameCorrectionPm {
    private final SimpleDocument regExDocument;
    private final SimpleDocument testDocument;
    private final JLabel testResult = new JLabel();

    public PrinterNameCorrectionPm(PrintNameCorrection correction) {
        this.regExDocument = new SimpleDocument();
        this.testDocument = new SimpleDocument();
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        String name = printService != null ? printService.getName() : "";
        this.testDocument.setText(name);
        this.regExDocument.setText(correction.getRegEx().getValue());
        this.updateTestLabel();
        StringNodeDocumentListener.register(correction.getRegEx(), this.regExDocument);
        this.regExDocument.addDocumentListener(new DocumentListenerAdapter(){

            @Override
            protected void contentChanged(DocumentEvent e2) {
                PrinterNameCorrectionPm.this.updateTestLabel();
            }
        });
        this.testDocument.addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void contentChanged(DocumentEvent e2) {
                PrinterNameCorrectionPm.this.updateTestLabel();
            }
        });
    }

    private void updateTestLabel() {
        this.testResult.setText(PrintNameCorrection.getCorrectedName(this.regExDocument.getText(), this.testDocument.getText()));
    }

    public SimpleDocument getRegExDocument() {
        return this.regExDocument;
    }

    public JLabel getTestLabel() {
        return this.testResult;
    }

    public SimpleDocument getTestDocument() {
        return this.testDocument;
    }
}

