/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.refund.voc.pm;

import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.EvvItemWrapper;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundSendingHandle;
import java.util.Date;

public class RefundItemHandle {
    private final RefundSendingHandle parent;
    private Double grossWeight;
    private Double netWeight;
    private String description;
    private Double voc;
    private String commodityCode;
    private DomainValue refundType;
    private boolean included = true;

    public RefundItemHandle(RefundSendingHandle parent, EvvItemWrapper item) throws Exception {
        this.parent = parent;
        this.grossWeight = item.getGrossMassDouble();
        this.netWeight = item.getNetMassDouble();
        this.description = item.getDescriptionShortString();
        this.voc = item.getVOCQuantityDouble();
        this.commodityCode = item.getCommodityCodeString();
        this.refundType = item.getRefundType();
    }

    public Double getGrossWeight() {
        return this.grossWeight;
    }

    public Double getNetWeight() {
        return this.netWeight;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getVoc() {
        return this.voc;
    }

    public String getCommodityCode() {
        return this.commodityCode;
    }

    public Date getDate() {
        return this.parent.getDate();
    }

    public DomainValue getRefundType() {
        return this.refundType;
    }

    public Object getCustomsDeclarationNumber() {
        return this.parent.getCustomsDeclarationNumber();
    }

    public Boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(Boolean value) {
        this.included = value;
    }

    public boolean hasVOC(RefundItemHandle refundItem) {
        if (this.getRefundType().getKey().equals("1")) {
            return true;
        }
        return this.getVoc() != null;
    }
}

