/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.refund.voc.pm;

import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.ISendingHandler;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.EvvDocWrapper;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundPm;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundSendingHandle;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.List;
import javax.swing.SwingWorker;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class RefundListFetcher
extends SwingWorker<Void, RefundSendingHandle>
implements ISendingHandler {
    private final Date to;
    private final Date from;
    private final Consignor consignor;
    private final RefundPm pm;

    public RefundListFetcher(RefundPm pm, Date from, Date to, Consignor consignor) {
        this.pm = pm;
        this.from = from;
        this.to = DateUtil.getEndOfDay(to);
        Check.assertNotNull(consignor);
        this.consignor = consignor;
        pm.getListSendings().setEnabled(false);
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        this.pm.getListSendings().setEnabled(true);
        this.pm.getExportButton().setEnabled(true);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.addAllEvvsToList();
        return null;
    }

    private void addAllEvvsToList() {
        for (int year = DateUtil.getYear(this.from); year <= DateUtil.getYear(this.to); ++year) {
            SendingUtil.handleSendingsOfOneYear(this, year);
        }
    }

    @Override
    protected void process(List<RefundSendingHandle> chunks) {
        if (this.isCancelled()) {
            return;
        }
        this.pm.publish(chunks);
    }

    @Override
    public void handle(File dir, File path, String yearPart, String sendingPart) {
        if (!path.exists()) {
            return;
        }
        try {
            Sending sending = new XMLReader().read(new FileInputStream(path), Sending.class);
            sending.setSendingId(yearPart + "-" + sendingPart);
            this.handle(sending);
        }
        catch (SAXParseException e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(4713) + "\n" + path);
        }
        catch (Exception e3) {
            Check.fail(e3);
        }
    }

    private void handle(Sending sending) throws Exception {
        Date date = sending.getAcceptanceDate().getValue();
        if (date == null) {
            return;
        }
        if (date.before(this.from) || date.after(this.to)) {
            return;
        }
        File evvPath = SendingUtil.getEvvPath(sending.getSendingId(), true);
        if (!evvPath.exists()) {
            return;
        }
        Document evvDoc = DocumentUtil.readXmlDoc(evvPath);
        StringNode selectedConsignorName = this.consignor.getName();
        String sendingConsignorName = sending.getGoodsDeclaration().getConsignor().getName().getValue();
        if (!selectedConsignorName.isInitialized() || selectedConsignorName.getValue().equalsIgnoreCase(sendingConsignorName)) {
            this.publish(new RefundSendingHandle(new EvvDocWrapper(evvDoc), date));
        }
    }
}

