/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.refund.voc.pm;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundItemHandle;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundSendingHandle;
import ch.transsoft.edec.ui.pm.model.IPm;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RefundListPm
extends AbstractTableModel
implements IPm {
    private static final Cols[] cols = Cols.values();
    private final List<RefundItemHandle> itemHandles = new ArrayList<RefundItemHandle>();
    private final List<RefundSendingHandle> sendingHandles = new ArrayList<RefundSendingHandle>();

    @Override
    public int getColumnCount() {
        return cols.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return cols[columnIndex].getType();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return cols[columnIndex].getName();
    }

    public Object getValueAt(int columnIndex) {
        return cols[columnIndex].getName();
    }

    @Override
    public int getRowCount() {
        return this.itemHandles.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return cols[columnIndex].getValue(this.itemHandles.get(rowIndex));
    }

    public void clear() {
        this.itemHandles.clear();
        this.sendingHandles.clear();
        this.fireTableDataChanged();
    }

    public List<RefundItemHandle> getList() {
        return this.itemHandles;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return cols[columnIndex].isEditable();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        cols[columnIndex].setValue(this.itemHandles.get(rowIndex), aValue);
    }

    public void add(List<RefundSendingHandle> handles) {
        for (RefundSendingHandle sendingHandle : handles) {
            this.sendingHandles.add(sendingHandle);
            this.itemHandles.addAll(sendingHandle.getItems());
        }
        this.fireTableDataChanged();
    }

    public List<RefundSendingHandle> getSendingHandles() {
        return this.sendingHandles;
    }

    private static enum Cols {
        date(Services.getText(2610), (Class)Date.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getDate();
            }
        }
        ,
        customsDeclarationNumber(Services.getText(2611), (Class)String.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getCustomsDeclarationNumber();
            }
        }
        ,
        grossWeight(Services.getText(2612), (Class)Double.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getGrossWeight();
            }
        }
        ,
        description(Services.getText(2613), (Class)String.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getDescription();
            }
        }
        ,
        netWeight(Services.getText(2614), (Class)Double.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getNetWeight();
            }
        }
        ,
        refundType(Services.getText(2618), (Class)String.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getRefundType().getDesc();
            }
        }
        ,
        voc(Services.getText(2615), (Class)Double.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getVoc();
            }
        }
        ,
        commodityCode(Services.getText(2616), (Class)String.class){

            @Override
            public Object getValue(RefundItemHandle data) {
                return data.getCommodityCode();
            }
        }
        ,
        included(Services.getText(2617), (Class)Boolean.class){

            @Override
            public Boolean getValue(RefundItemHandle data) {
                return data.getIncluded();
            }

            @Override
            public boolean isEditable() {
                return true;
            }

            @Override
            public void setValue(RefundItemHandle data, Object value) {
                data.setIncluded((Boolean)value);
            }
        };

        private final String name;
        private final Class<?> type;

        private Cols(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public abstract Object getValue(RefundItemHandle var1);

        public boolean isEditable() {
            return false;
        }

        public void setValue(RefundItemHandle data, Object value) {
        }
    }
}

