/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.refund.voc.pm;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundItemHandle;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundListFetcher;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundListPm;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundSendingHandle;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.ISelectionPm;
import ch.transsoft.edec.ui.pm.sending.heading.ConsignorPm;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.GuiUtil;
import ch.transsoft.edec.util.NumberUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import com.lowagie.text.html.HtmlEncoder;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class RefundPm
implements IPm {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private final JDateChooser from;
    private final JDateChooser to;
    private final JButton listPositions;
    private final JLabel statusLabel;
    private final Component progressBar;
    private final RefundListPm refundListPm;
    private final ConsignorPm consignorPm;
    private final JButton exportButton = new JButton(Services.getText(4756), IconLoader.getIcon("icon/pdf-24x24.png"));
    private final JButton closeButton = new JButton(Services.getText(209));
    private double weightTotal;
    private double netWeightTotal;
    private double vocTotal;

    public RefundPm() {
        this.from = new JDateChooser();
        this.to = new JDateChooser();
        this.consignorPm = new ConsignorPm(NodeFactory.create(Consignor.class));
        this.listPositions = new JButton(Services.getText(2604));
        this.refundListPm = new RefundListPm();
        this.progressBar = this.createProgressBar();
        this.statusLabel = new JLabel();
        this.exportButton.setEnabled(false);
        this.hideStatusInfo();
        this.addButtonListener();
    }

    private void addButtonListener() {
        this.listPositions.addActionListener(e2 -> this.listPositions());
        this.exportButton.addActionListener(e2 -> this.createPdf());
        this.closeButton.addActionListener(e2 -> GuiUtil.getWindowAncestor(e2).dispose());
    }

    protected void listPositions() {
        if (!this.rangeValid()) {
            DialogUtil.showWarningDialog(Services.getText(4706), Services.getText(4707));
            return;
        }
        this.refundListPm.clear();
        Consignor consignor = (Consignor)this.consignorPm.getSelectedItem();
        RefundListFetcher listFetchWorker = new RefundListFetcher(this, this.from.getDate(), this.to.getDate(), consignor);
        this.setStatusInfo(Services.getText(865));
        listFetchWorker.execute();
    }

    private void createPdf() {
        this.clearTotals();
        String html = this.createHtml();
        try {
            File destPath = FileUtil.createTempFileName("VOC", "pdf");
            FileOutputStream fos = new FileOutputStream(destPath);
            PdfWriter writer = new PdfWriter();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(html)));
            writer.htmlToPDF(fos, doc);
            DocumentUtil.showDoc(destPath);
        }
        catch (Exception e2) {
            System.out.println(html);
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(2619));
        }
    }

    private String createHtml() {
        StringBuilder result = new StringBuilder();
        this.appendLine(result, "<!DOCTYPE html>");
        this.appendLine(result, "<html>");
        this.appendLine(result, "<head>");
        this.appendLine(result, "<style>");
        this.appendLine(result, "@page {size: A4 landscape;}");
        this.appendCssClass(result, "table", "border-collapse: collapse;", "page-break-inside:auto;");
        this.appendCssClass(result, "tr", "page-break-inside:avoid;");
        this.appendCssClass(result, ".tr_nobreak", "page-break-inside:avoid;", "page-break-before: avoid;");
        this.appendCssClass(result, "th", "border:1px solid black;");
        this.appendCssClass(result, ".td_border", "border:1px solid black;");
        this.appendCssClass(result, ".td_no_border", "border-top:none;", "border-bottom:none;", "border-right:1px solid black;", "border-left:1px solid black;");
        this.appendCssClass(result, ".td_never_border", "border:none;");
        this.appendCssClass(result, ".td_no_top_border", "border-top:none;", "border-bottom:1px solid black;", "border-right:1px solid black;", "border-left:1px solid black;");
        this.appendCssClass(result, ".imgtd", "border:1px solid black;", "padding-left: 16px;", "padding-right: 16px;", "page-break-inside:avoid;");
        this.appendLine(result, "</style>");
        this.appendLine(result, "</head>");
        this.appendLine(result, "<body>");
        this.appendLine(result, "<p><h2>Detailabrechnung VOC<br/>Export</h2></p>");
        this.appendLine(result, "<p>");
        this.appendLine(result, "  <table width=\"100%\">");
        this.appendLine(result, "    <tr>");
        this.appendLine(result, "     <td><b>Firmenname:</b></td>");
        this.appendLine(result, "     <td><b>Abrechnungsperiode:</b></td>");
        this.appendLine(result, "    </tr>");
        this.appendLine(result, "    <tr>");
        this.appendLine(result, "<td valign=\"top\">");
        this.appendConsignor(result, (Consignor)this.consignorPm.getSelectedItem());
        this.appendLine(result, "     </td>");
        this.appendLine(result, "     <td valign=\"top\">");
        this.appendPeriod(result, this.from, this.to);
        this.appendLine(result, "     </td>");
        this.appendLine(result, "    </tr>");
        this.appendLine(result, "  </table>");
        this.appendLine(result, "</p>");
        this.appendLine(result, "<br/>");
        this.appendLine(result, "<br/>");
        this.appendLine(result, "<table cellpadding=\"6\">");
        this.appendLine(result, " <tr>");
        this.appendLine(result, "  <th valign=\"top\">Ausfuhrdatum</th>");
        this.appendLine(result, "  <th valign=\"top\">Barcode</th>");
        this.appendLine(result, "  <th valign=\"top\">Gewicht Lieferung</th>");
        this.appendLine(result, "  <th valign=\"top\">Warenbezeichnung</th>");
        this.appendLine(result, "  <th valign=\"top\">Eigenmasse</th>");
        this.appendLine(result, "  <th valign=\"top\">VOC-Menge in kg</th>");
        this.appendLine(result, "  <th valign=\"top\">Tarif-Nummer</th>");
        this.appendLine(result, "</tr>");
        this.appendGoodsItems(result, this.refundListPm.getSendingHandles());
        this.appendTotals(result);
        this.appendLine(result, "</table>");
        this.appendLine(result, "</body>");
        this.appendLine(result, "</html>");
        return result.toString();
    }

    private void appendTotals(StringBuilder result) {
        String tdBorder = "td_no_top_border";
        String tdNoBorder = "td_never_border";
        this.appendLine(result, "<tr>");
        this.appendLine(result, "<td class=\"" + tdNoBorder + "\" align=\"right\" valign=\"top\"></td>");
        this.appendLine(result, "<td class=\"" + tdNoBorder + "\" align=\"right\" valign=\"top\"></td>");
        this.appendLine(result, "<td class=\"" + tdBorder + "\" align=\"right\" valign=\"top\"><b>" + NumberUtil.format(3, this.weightTotal) + "</b></td>");
        this.appendLine(result, "<td class=\"" + tdBorder + "\" align=\"right\" valign=\"top\" width=\"20%\"></td>");
        this.appendLine(result, "<td class=\"" + tdBorder + "\" align=\"right\" valign=\"top\"><b>" + NumberUtil.format(3, this.netWeightTotal) + "</b></td>");
        this.appendLine(result, "<td class=\"" + tdBorder + "\" align=\"right\" valign=\"top\"><b>" + NumberUtil.format(3, this.vocTotal) + "</b></td>");
        this.appendLine(result, "<td class=\"" + tdBorder + "\" align=\"right\" valign=\"top\"></td>");
        this.appendLine(result, "</tr>");
    }

    private void clearTotals() {
        this.weightTotal = 0.0;
        this.netWeightTotal = 0.0;
        this.vocTotal = 0.0;
    }

    private void appendLine(StringBuilder result, String string) {
        result.append(string);
        result.append("\n");
    }

    private void appendGoodsItems(StringBuilder result, List<RefundSendingHandle> sendingHandles) {
        for (RefundSendingHandle sendingHandle : sendingHandles) {
            this.appendSendingHandle(result, sendingHandle);
        }
    }

    private void appendSendingHandle(StringBuilder result, RefundSendingHandle sendingHandle) {
        ArrayList<RefundItemHandle> itemList = new ArrayList<RefundItemHandle>();
        for (RefundItemHandle item : sendingHandle.getItems()) {
            if (!item.getIncluded().booleanValue()) continue;
            itemList.add(item);
        }
        if (itemList.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < itemList.size(); ++i2) {
            RefundItemHandle item;
            if (i2 > 0) {
                this.appendLine(result, " <tr class=\".tr_nobreak\">");
            } else {
                this.appendLine(result, " <tr>");
            }
            if (i2 == 0) {
                this.appendDateAndBarcode(result, sendingHandle, itemList.size());
            }
            item = (RefundItemHandle)itemList.get(i2);
            String tdClass = i2 == itemList.size() - 1 ? "td_no_top_border" : "td_no_border";
            this.appendLine(result, "<td class=\"" + tdClass + "\" align=\"right\" valign=\"top\">" + NumberUtil.format(3, item.getGrossWeight()) + "</td>");
            this.appendLine(result, "<td class=\"" + tdClass + "\" align=\"right\" valign=\"top\" width=\"20%\">" + this.encodeHTML(item.getDescription()) + "</td>");
            this.appendLine(result, "<td class=\"" + tdClass + "\" align=\"right\" valign=\"top\">" + NumberUtil.format(3, item.getNetWeight()) + "</td>");
            this.appendLine(result, "<td class=\"" + tdClass + "\" align=\"right\" valign=\"top\">" + NumberUtil.format(3, item.getVoc()) + "</td>");
            this.appendLine(result, "<td class=\"" + tdClass + "\" align=\"right\" valign=\"top\">" + item.getCommodityCode() + "</td>");
            this.appendLine(result, "</tr>");
            if (item.getGrossWeight() != null) {
                this.weightTotal += item.getGrossWeight().doubleValue();
            }
            if (item.getNetWeight() != null) {
                this.netWeightTotal += item.getNetWeight().doubleValue();
            }
            if (item.getVoc() == null) continue;
            this.vocTotal += item.getVoc().doubleValue();
        }
    }

    private String encodeHTML(String description) {
        if (description == null) {
            return "";
        }
        return HtmlEncoder.encode(description);
    }

    private void appendDateAndBarcode(StringBuilder result, RefundSendingHandle sendingHandle, int itemCount) {
        this.appendLine(result, "  <td class=\"td_border\" valign=\"top\" rowspan=\"" + itemCount + "\">" + DateUtil.formatDate(sendingHandle.getDate()) + "</td>");
        String barcode = sendingHandle.getCustomsDeclarationNumber();
        this.appendLine(result, "<td class=\"imgtd\" rowspan=\"" + itemCount + "\"  valign=\"top\" width=\"10%\"><img height=\"50\" src=\"barcode/" + barcode + "\"/>" + barcode + "</td>");
    }

    private void appendPeriod(StringBuilder result, JDateChooser fromDataChooser, JDateChooser toDataChooser) {
        String str = DateUtil.formatDate(fromDataChooser.getDate()) + " - " + DateUtil.formatDate(toDataChooser.getDate());
        this.appendLine(result, str);
    }

    private void appendConsignor(StringBuilder result, Consignor consignor) {
        consignor.getAddress().apply(result, "<br/>");
    }

    private void appendCssClass(StringBuilder result, String name, String ... lines) {
        this.appendLine(result, name);
        this.appendLine(result, "{");
        for (String line : lines) {
            this.appendLine(result, "  " + line);
        }
        this.appendLine(result, "}");
    }

    private boolean rangeValid() {
        if (this.getFromDate() == null) {
            return false;
        }
        if (this.getToDate() == null) {
            return false;
        }
        return this.getFromDate().compareTo(this.getToDate()) <= 0;
    }

    public Date getFromDate() {
        if (this.from.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.from.getDate());
    }

    public Date getToDate() {
        if (this.to.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.to.getDate());
    }

    public Component getFrom() {
        return this.from;
    }

    public Component getTo() {
        return this.to;
    }

    private JProgressBar createProgressBar() {
        JProgressBar result = new JProgressBar();
        result.setIndeterminate(true);
        return result;
    }

    public void hideStatusInfo() {
        this.statusLabel.setVisible(false);
        this.progressBar.setVisible(false);
    }

    public void setStatusInfo(String text) {
        this.statusLabel.setText("<html>" + text + "</html>");
        this.statusLabel.setVisible(true);
        this.progressBar.setVisible(true);
    }

    public TableModel getListPm() {
        return this.refundListPm;
    }

    public Component getListSendings() {
        return this.listPositions;
    }

    public void publish(List<RefundSendingHandle> chunks) {
        this.refundListPm.add(chunks);
    }

    public ISelectionPm<Object> getConsignorPm() {
        return this.consignorPm;
    }

    public JButton getExportButton() {
        return this.exportButton;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }
}

