/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.SafeTransactionReporter;
import ch.transsoft.edec.service.certificate.ICertificateService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ExpoVitEdecExceptionHandler;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.polling.IPollingService;
import ch.transsoft.edec.service.proxy.IConnectionService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.EscapeDialog;
import ch.transsoft.edec.ui.dialog.info.gui.InfoDialog;
import ch.transsoft.edec.ui.dialog.license.gui.LicenseDialog;
import ch.transsoft.edec.ui.gui.CertificateExpirationDialog;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.RootFolderNewerDialogLauncher;
import ch.transsoft.edec.ui.gui.RootFolderNewerDialogRunnableJar;
import ch.transsoft.edec.ui.gui.UpdateDialogLauncher;
import ch.transsoft.edec.ui.gui.UpdateDialogRunnableJar;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SystemUtil;
import ch.transsoft.edec.util.Version;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExpoVit {
    private static final int WINDOW_WIDTH = 1024;
    public static final int WINDOW_HEIGHT = 778;

    public static void main(String[] args) {
        ExpoVit.setExceptionHandlers();
        Locale.setDefault(new Locale("de", "CH"));
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        ExpoVit.setLAF();
        SwingUtilities.invokeLater(() -> {
            ExpoVit.logStartUp();
            ExpoVit.addShutdownHook();
            if (!ExpoVit.safeCheckSyncRootFolderVersion()) {
                System.exit(0);
            }
            Services.get(IConnectionService.class).init();
            Services.get(ICertificateService.class).init();
            ExpoVit.createAndShowGUI();
            ExpoVit.showCertificateExpirationWarning();
            Services.get(IPollingService.class).startStatePolling();
            Services.get(IPollingService.class).startEdecMailPolling();
            Services.get(IPollingService.class).startEvvImportPolling();
            ExpoVit.checkAsyncForNewerVersion();
            ExpoVit.checkAsyncTransactionBacklog();
            if (Services.get(IConfigService.class).registrationComplete()) {
                Services.get(IPollingService.class).startEVVpolling();
            } else {
                ExpoVit.showLicenseDialog();
            }
        });
        SwingUtilities.invokeLater(ExpoVit::logUiReady);
    }

    private static void logUiReady() {
        Services.get(ILoggingService.class).logSilent("ExpoVit UI ready.");
    }

    private static void showCertificateExpirationWarning() {
        if (!CertificateExpirationDialog.showCertificateExpirationWarning()) {
            return;
        }
        CertificateExpirationDialog dialog = new CertificateExpirationDialog();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        DialogUtil.centerDialog(dialog, 650, 350, new Rectangle(0, 0, screenSize.width, screenSize.height));
        dialog.setVisible(true);
    }

    private static boolean safeCheckSyncRootFolderVersion() {
        try {
            return ExpoVit.checkSyncRootFolderVersion();
        }
        catch (Exception e2) {
            return true;
        }
    }

    private static boolean checkSyncRootFolderVersion() throws Exception {
        String rootFolderVersion;
        File path = Services.get(IConfigService.class).getVersionFilePath();
        try (BufferedReader reader = FileUtil.createFileReader(path);){
            rootFolderVersion = reader.readLine();
        }
        if (rootFolderVersion == null) {
            return true;
        }
        String currentVersion = Services.get(IConfigService.class).getVersionString();
        if (Version.majorMinorEquals(rootFolderVersion, currentVersion)) {
            return true;
        }
        if (!Version.isSmaller(currentVersion, rootFolderVersion)) {
            return true;
        }
        String title = Services.getText(1572);
        EscapeDialog dialog = SystemUtil.isLaunchedByLauncher() ? new RootFolderNewerDialogLauncher(title, rootFolderVersion, currentVersion) : new RootFolderNewerDialogRunnableJar(title, rootFolderVersion, currentVersion);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        DialogUtil.centerDialog(dialog, 650, 350, new Rectangle(0, 0, screenSize.width, screenSize.height));
        dialog.setVisible(true);
        return false;
    }

    private static void checkAsyncTransactionBacklog() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return SafeTransactionReporter.isBacklogCritical();
            }

            @Override
            protected void done() {
                boolean hasToShowDialog = false;
                try {
                    hasToShowDialog = (Boolean)this.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                if (!hasToShowDialog) {
                    return;
                }
                InfoDialog.showDialog();
            }
        };
        worker.execute();
    }

    private static void checkAsyncForNewerVersion() {
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                URL url = new URI("https://launcher.expovit-edec.ch/run.jnlp").toURL();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(url.openStream());
                Node el = doc.getElementsByTagName("jnlp").item(0);
                return el.getAttributes().getNamedItem("version").getNodeValue();
            }

            @Override
            protected void done() {
                try {
                    String remoteVersion = (String)this.get();
                    String localVersion = Services.get(IConfigService.class).getVersionString();
                    if (Version.majorMinorEquals(localVersion, remoteVersion)) {
                        return;
                    }
                    if (Version.isSmaller(localVersion, remoteVersion)) {
                        ExpoVit.showUpdateDialog(remoteVersion);
                    }
                }
                catch (Exception e2) {
                    Services.get(ILoggingService.class).logSilentWithBugMail(e2, "Failed to get version from JNLP-file");
                }
            }
        };
        worker.execute();
    }

    private static void showUpdateDialog(String remoteVersion) {
        String title = "Update " + remoteVersion;
        EscapeDialog dialog = SystemUtil.isLaunchedByLauncher() ? new UpdateDialogLauncher(title) : new UpdateDialogRunnableJar(title);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        DialogUtil.centerDialog(dialog, 650, 350, new Rectangle(0, 0, screenSize.width, screenSize.height));
        dialog.setVisible(true);
    }

    private static void setLAF() {
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            UIManager.put("TabbedPane.background", Design.TAB_DISABLED_BG);
            UIManager.put("TabbedPane.selected", Design.BG);
            UIManager.put("TabbedPane.contentAreaColor", Design.BG);
        }
        catch (UnsupportedLookAndFeelException e2) {
            Check.fail(e2);
        }
    }

    private static void setExceptionHandlers() {
        System.setProperty("sun.awt.exception.handler", ExpoVitEdecExceptionHandler.class.getName());
        Thread.setDefaultUncaughtExceptionHandler((thread, t) -> SwingUtilities.invokeLater(() -> {
            if (ExpoVitEdecExceptionHandler.isIgnorableException(t)) {
                Services.get(ILoggingService.class).logSilent(t, "Default-handler: Ignorable Exception");
                return;
            }
            Services.get(ILoggingService.class).logUncaughtException(t, thread.getName());
        }));
    }

    private static void addShutdownHook() {
        Runnable runnable = () -> Services.get(ILoggingService.class).logSilent("ExpoVit closed");
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }

    private static void logStartUp() {
        Services.get(ILoggingService.class).logSilent("ExpoVit started. " + SystemUtil.getDebugVersionString());
    }

    private static void logSystemProperties() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Object, Object> e2 : System.getProperties().entrySet()) {
            result.append(e2.getKey());
            result.append(": ");
            result.append(e2.getValue());
            result.append("\n");
        }
        Services.get(ILoggingService.class).logSilent(result.toString());
    }

    private static void showLicenseDialog() {
        new LicenseDialog().setVisible(true);
    }

    private static void createAndShowGUI() {
        JFrame frame = Services.get(IGuiService.class).createMainFrame();
        frame.setSize(1024, 778);
        frame.setExtendedState(6);
        frame.setVisible(true);
    }
}

