/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.app.AppState;
import ch.transsoft.edec.service.app.IAppChangedListener;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.MainPanelColorStrategy;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.tabs.AppStateAwareTabPane;
import ch.transsoft.edec.ui.gui.control.tabs.TabbedPane;
import ch.transsoft.edec.ui.gui.imp.ImportPanel;
import ch.transsoft.edec.ui.gui.sending.SendingPanel;
import ch.transsoft.edec.ui.gui.sendinglist.SendingListPanel;
import ch.transsoft.edec.ui.gui.templates.TemplatePanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.ExportPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ReflectionUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ExportPanel
extends JPanel {
    private static final String ICON_SENDING = "icon/sending-32x36.png";
    private static final String ICON_SENDINGLIST = "icon/sendinglist-32x36.png";
    private static final String ICON_TEMPLATE = "icon/Template-32x36.png";
    private static final String ICON_IMPORT = "icon/Import-32x36.png";
    private final DefaultPanel sendingPanelContainer = new DefaultPanel();
    private static final int TEMPLATE_TAB = 0;
    private static final int IMPORT_TAB = 1;
    private static final int SENDING_LIST_TAB = 2;
    private static final int SENDING_TAB = 3;
    private TabbedPane tabbedPane;
    private SendingPanel currentSendingPanel;
    private final ExportPm exportPm;

    public ExportPanel(ExportPm exportPm) {
        this.exportPm = exportPm;
        this.sendingPanelContainer.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.setBackground(Design.BG);
        this.add(this.createToolbarPanel(), "North");
        this.add(this.createContent(), "Center");
        this.addTabListener();
        this.addSendingListener();
        this.setSending(Services.get(IAppService.class).getCurrentSending());
    }

    private void addTabListener() {
        this.tabbedPane.addChangeListener(e2 -> {
            Services.get(IActionService.class).tabChanged(this.tabbedPane.getSelectedIndex());
            if (this.tabbedPane.getSelectedIndex() == 1) {
                Services.get(IGuiService.class).refreshImportModel(false);
            }
        });
    }

    private void addSendingListener() {
        this.exportPm.add(Services.get(IAppService.class).addChangeListener(new IAppChangedListener(){

            @Override
            public void sendingChanged(Sending sending) {
                ExportPanel.this.setSending(sending);
            }

            @Override
            public void stateChanged(AppState state, File template) {
                Sending sending = ExportPanel.this.getAppService().getCurrentSending();
                ExportPanel.this.updateTitle(sending);
                ExportPanel.this.updateIcon(state);
            }
        }));
    }

    protected void updateIcon(AppState state) {
        if (state == AppState.template) {
            this.tabbedPane.setIconAt(3, this.getIcon(ICON_TEMPLATE));
        } else {
            this.tabbedPane.setIconAt(3, this.getIcon(ICON_SENDING));
        }
    }

    private IAppService getAppService() {
        return Services.get(IAppService.class);
    }

    private void addTraderDeclarationNumberListener(Sending sending) {
        this.exportPm.getCurrentSendingPm().getDisposables().add(sending.addChangeListener((source, info) -> this.updateTitle(sending)));
    }

    private void updateTitle(Sending sending) {
        String title = (sending.hasPendingChanges() ? "*" : "") + this.getSendingTitle(sending.getTraderDeclarationNumber());
        this.tabbedPane.setTitleAt(3, title);
    }

    private String getSendingTitle(String traderDeclarationNumber) {
        switch (this.getAppService().getAppState()) {
            case newSending: {
                return this.getText(405);
            }
            case sending: {
                return this.getText(406) + (traderDeclarationNumber.isEmpty() ? "" : " ") + traderDeclarationNumber;
            }
            case template: {
                return this.getText(407) + " " + this.getAppService().getCurrentTemplate().getName();
            }
        }
        throw Check.fail("unknown state");
    }

    private Component createToolbarPanel() {
        DefaultPanel result = new DefaultPanel();
        result.setLayout(new MigLayout("fill", "0[grow]0[]0", "0[]0"));
        result.add(Services.get(IActionService.class).createToolbar(), "growx");
        result.add((Component)Services.get(IGuiService.class).getStatusDisplay(), "growy");
        return result;
    }

    private Component createContent() {
        this.tabbedPane = new AppStateAwareTabPane(this.exportPm.getDisposables(), new MainPanelColorStrategy());
        this.tabbedPane.setOpaque(false);
        this.tabbedPane.setPreferredSize(new Dimension(500, 500));
        Font font = new Font(this.tabbedPane.getFont().getName(), 1, 12);
        this.tabbedPane.setFont(font);
        this.tabbedPane.addTab(this.getText(404), this.getIcon(ICON_TEMPLATE), new TemplatePanel());
        this.tabbedPane.addTab(this.getText(408), this.getIcon(ICON_IMPORT), new ImportPanel());
        this.tabbedPane.addTab(this.getText(402), this.getIcon(ICON_SENDINGLIST), new SendingListPanel(this.exportPm));
        this.tabbedPane.addTab("", this.getIcon(ICON_SENDING), this.sendingPanelContainer);
        this.tabbedPane.setBackgroundAt(0, Color.blue);
        return this.tabbedPane;
    }

    private void setSending(Sending sending) {
        if (this.exportPm.hasCurrentSending()) {
            this.sendingPanelContainer.removeAll();
            ReflectionUtil.recursiveDispose(this.exportPm.getCurrentSendingPm());
        }
        this.tabbedPane.removeAllErrors();
        this.exportPm.createNewSendingPm(sending);
        this.currentSendingPanel = new SendingPanel(this.exportPm.getCurrentSendingPm());
        this.sendingPanelContainer.add(this.currentSendingPanel);
        this.tabbedPane.validate();
        this.updateTitle(sending);
        this.addErrorListener();
        this.addTraderDeclarationNumberListener(sending);
    }

    private void addErrorListener() {
        this.exportPm.getCurrentSendingPm().add((ErrorInfo errorInfo) -> {
            if (errorInfo.hasError()) {
                this.tabbedPane.setError(3, errorInfo);
            } else {
                this.tabbedPane.removeError(3);
            }
        });
    }

    public void selectImport() {
        this.tabbedPane.setSelectedIndex(1);
    }

    public void selectTemplate() {
        this.tabbedPane.setSelectedIndex(0);
    }

    public void selectSendingList() {
        this.tabbedPane.setSelectedIndex(2);
    }

    public void selectSending() {
        this.tabbedPane.setSelectedIndex(3);
    }

    public void selectHeader() {
        this.selectSending();
        this.currentSendingPanel.selectHeader();
    }

    public void selectItemList() {
        this.selectSending();
        this.currentSendingPanel.selectItemList();
    }

    public void selectForms() {
        this.selectSending();
        this.currentSendingPanel.selectForms();
    }

    private Icon getIcon(String string) {
        return IconLoader.getIcon(string);
    }

    private String getText(int id) {
        return Services.get(ITextService.class).getText(id);
    }
}

