/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.bar;

import ch.transsoft.edec.model.config.pref.mandator.Mandator;
import ch.transsoft.edec.model.config.pref.mandator.MandatorInfo;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.IBackendWorkerListener;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.IMasterDataEZVService;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.IModulePm;
import ch.transsoft.edec.util.Check;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;

public class StateDisplay
extends DefaultPanel {
    private final JLabel label;
    private final JProgressBar bar;
    private final JLabel interruptButton;
    private final JLabel operatingModeLabel = new JLabel();
    private final JComboBox<Mandator> mandators = new JComboBox();
    private final JComboBox<DomainValue> moduleSelection = new JComboBox();
    private boolean updating = false;

    public StateDisplay(IModulePm modulePm) {
        Check.checkEDT();
        this.setLayout(new MigLayout("fill", "[]50[]50[]10[]", "0[40!]2[28!, top]0"));
        this.moduleSelection.setToolTipText(Services.getText(130));
        this.add(this.moduleSelection, "spany 2, width 100!, height 22!");
        this.addModuleSelection();
        this.addModuleListener();
        this.mandators.setToolTipText(Services.getText(111));
        this.add(this.mandators, "spany 2, width 150!, height 22!");
        this.addMandators();
        this.addMandatorListener(modulePm);
        this.add((Component)this.operatingModeLabel, "spany 2, width 200!");
        this.operatingModeLabel.setToolTipText(Services.format(112, 102));
        this.label = new JLabel();
        Font f2 = this.label.getFont();
        this.label.setFont(new Font(f2.getName(), 0, f2.getSize()));
        this.add((Component)this.label, "width 250!, height ::50, wrap, bottom");
        this.bar = new JProgressBar();
        this.bar.setIndeterminate(true);
        this.add((Component)this.bar, "growx, height 10!, top,gapy 1, split 2");
        this.interruptButton = new JLabel(IconLoader.getIcon("icon/Delete-Table-small.png"));
        this.interruptButton.setEnabled(false);
        this.add((Component)this.interruptButton, "width !, height 10!");
        this.hidePanel();
        this.addUpdateOperatingModeListener(modulePm);
        this.addActionLockListeners(modulePm);
        this.addInterruptListener();
    }

    private void addInterruptListener() {
        this.interruptButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                StateDisplay.this.interruptButton.setEnabled(false);
                Services.get(IBackendService.class).interruptCurrentJob();
            }
        });
    }

    private void addActionLockListeners(IModulePm modulePm) {
        modulePm.add(Services.get(IBackendService.class).add(new IBackendWorkerListener(){

            @Override
            public void busy() {
                StateDisplay.this.mandators.setEnabled(false);
                StateDisplay.this.moduleSelection.setEnabled(false);
            }

            @Override
            public void idle() {
                StateDisplay.this.mandators.setEnabled(true);
                StateDisplay.this.moduleSelection.setEnabled(true);
            }
        }));
    }

    private void addModuleListener() {
        this.moduleSelection.addActionListener(e2 -> {
            if (this.updating) {
                return;
            }
            this.updating = true;
            try {
                Services.get(IConfigService.class).getPreferences().getModuleSelection().setValue(this.moduleSelection.getSelectedItem(), true);
                Services.get(IConfigService.class).savePreferences();
                Services.get(IGuiService.class).moduleChanged();
            }
            finally {
                this.updating = false;
            }
        });
    }

    private void addMandatorListener(IModulePm modulePm) {
        this.mandators.addActionListener(e2 -> {
            if (this.updating) {
                return;
            }
            this.updating = true;
            try {
                Mandator current = (Mandator)this.mandators.getSelectedItem();
                if (current == null) {
                    return;
                }
                Services.get(IAppService.class).closeCurrentSending();
                Services.get(IConfigService.class).changeRootFolder(current.getRootFolder().getValue(), false);
            }
            finally {
                this.updating = false;
            }
        });
        modulePm.add(Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void rootChanged() {
                StateDisplay.this.adjustMandator();
            }
        }));
    }

    private void adjustMandator() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            Mandator mandator = this.findMandator();
            this.mandators.setSelectedItem(mandator);
        }
        finally {
            this.updating = false;
        }
    }

    private void adjustModule() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.moduleSelection.setSelectedItem(Services.get(IConfigService.class).getPreferences().getModuleSelection().getValue());
        }
        finally {
            this.updating = false;
        }
    }

    private Mandator findMandator() {
        File root = Services.get(IConfigService.class).getRootFolder();
        for (int i2 = 0; i2 < this.mandators.getItemCount(); ++i2) {
            Mandator current = this.mandators.getItemAt(i2);
            if (!current.getRootFolder().getValue().equals(root)) continue;
            return current;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMandators() {
        this.updating = true;
        try {
            MandatorInfo info = (MandatorInfo)Services.get(IConfigService.class).getMandatorInfo().getCopy((ModelNode)null);
            this.mandators.setVisible(!info.getMandators().isEmpty());
            this.mandators.removeAllItems();
            for (Mandator current : info.getMandators()) {
                this.mandators.addItem(current);
            }
        }
        finally {
            this.updating = false;
        }
        this.adjustMandator();
    }

    private void addModuleSelection() {
        this.updating = true;
        try {
            for (DomainValue value : Services.get(IMasterDataEZVService.class).getDomainData(Domain.moduleSelection, false)) {
                this.moduleSelection.addItem(value);
            }
        }
        finally {
            this.updating = false;
        }
        this.adjustModule();
    }

    private void addUpdateOperatingModeListener(IModulePm modulePm) {
        this.updateOperatingModeLabel();
        modulePm.add(Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void rootChanged() {
            }

            @Override
            public void modeChanged(boolean isDemo) {
                StateDisplay.this.updateOperatingModeLabel();
            }

            @Override
            public void configurationChanged() {
                StateDisplay.this.updateOperatingModeLabel();
                StateDisplay.this.addMandators();
            }
        }));
    }

    private void updateOperatingModeLabel() {
        switch (Services.get(IConfigService.class).getOperatingModeForActiveModule()) {
            case test: {
                this.operatingModeLabel.setIcon(IconLoader.getIcon(Services.getText(114)));
                break;
            }
            case production: {
                this.operatingModeLabel.setIcon(IconLoader.getIcon(Services.getText(115)));
                break;
            }
            case undefined: {
                this.operatingModeLabel.setIcon(null);
            }
        }
    }

    public boolean isContentVisible() {
        return this.bar.isVisible();
    }

    public void hidePanel() {
        Check.checkEDT();
        this.bar.setVisible(false);
        this.label.setVisible(false);
        this.interruptButton.setVisible(false);
        this.interruptButton.setEnabled(false);
    }

    public void setVisible(String message, boolean interruptible) {
        Check.checkEDT();
        this.bar.setVisible(true);
        this.label.setVisible(true);
        if (interruptible) {
            this.interruptButton.setVisible(true);
            this.interruptButton.setEnabled(true);
        }
        this.stateWork(message);
    }

    public void stateWork(String message) {
        Check.checkEDT();
        this.label.setText("<html>" + message + "</html>");
    }

    public void stateWait(String user) {
        Check.checkEDT();
        this.label.setText("<html>" + Services.getText(113) + " " + user + "</html>");
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        int w = this.getWidth();
        int h2 = this.getHeight();
        Color c1 = new Color(255, 255, 255);
        Color c2 = new Color(220, 220, 220);
        g22.setColor(new Color(200, 200, 200));
        g22.drawLine(0, h2 - 1, w, h2 - 1);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, c1, 0.0f, h2, c2);
        g22.setPaint(gp);
        g22.fillRect(0, 0, w, h2 - 2);
        super.paintComponent(g2);
    }
}

