/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control;

import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.pm.model.IBooleanPm;
import javax.swing.JCheckBox;

public class BooleanField
extends JCheckBox {
    private IBooleanPm model;

    public BooleanField(IBooleanPm model, String text) {
        this(text);
        this.setModel(model);
    }

    public BooleanField(String text) {
        super(text);
        this.setBackground(Design.ERROR_COLOR);
    }

    public void setModel(IBooleanPm model) {
        this.model = model;
        super.setModel(model);
        this.setErrorState(model.getErrorInfo());
        this.addErrorListener();
    }

    private void setErrorState(ErrorInfo info) {
        this.setToolTipText(info.getMesage());
        if (info.hasError()) {
            this.setOpaque(true);
            return;
        }
        this.setOpaque(false);
    }

    private void addErrorListener() {
        this.model.addErrorListener(this::setErrorState);
    }
}

