/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.IInputField;
import ch.transsoft.edec.ui.pm.model.DecimalPm;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class DecimalField
extends JTextField
implements ActionListener,
FocusListener,
IInputField {
    private DecimalPm model;

    public DecimalField(DecimalPm doc) {
        this();
        this.setModel(doc);
    }

    public DecimalField() {
        this.setBorder(new LineBorder(Design.CONTROL_BORDER, 1));
        this.addAffirmListener();
    }

    public void setModel(DecimalPm doc) {
        this.model = doc;
        this.setDocument(doc);
        this.setErrorState(this.model.getErrorInfo());
        this.addErrorListener();
        this.addEnableListener();
    }

    private void addEnableListener() {
        this.setEnabled(this.model.isEnabled());
        this.model.add(new IPmListener(){

            @Override
            public void enabled(boolean value) {
                DecimalField.this.setEnabled(value);
            }

            @Override
            public void editable(boolean editable, String reason) {
            }
        });
    }

    private void setErrorState(ErrorInfo info) {
        this.setToolTipText(info.getMesage());
        if (info.hasError()) {
            this.setBackground(Design.ERROR_COLOR);
            return;
        }
        if (!this.isEditable()) {
            this.setBackground(Design.CONTROL_BG_READ_ONLY);
            return;
        }
        if (this.model.isMandatory()) {
            this.setBackground(Design.CONTROL_BG_MANDATORY);
        } else {
            this.setBackground(Design.CONTROL_BG);
        }
    }

    private void addErrorListener() {
        this.model.addErrorListener(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                DecimalField.this.setErrorState(errorInfo);
            }
        });
    }

    private void addAffirmListener() {
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.affirm();
    }

    @Override
    public void focusGained(FocusEvent e2) {
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.affirm();
    }

    private void affirm() {
        this.model.triggerDataChanged();
    }

    @Override
    public void commit() {
        this.affirm();
    }

    @Override
    public void save() {
    }

    public DecimalField setReadOnly() {
        this.setBackground(Design.CONTROL_BG_READ_ONLY);
        this.setEditable(false);
        return this;
    }
}

