/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control;

import ch.transsoft.edec.ui.gui.Design;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class MasterDataFieldRenderer
extends JComponent
implements ListCellRenderer<Object> {
    private Object current;
    private final int gapx;
    private final int gapy;
    private final boolean isMandatory;

    public MasterDataFieldRenderer(int gapx, int gapy, boolean isMandatory) {
        this.gapx = gapx;
        this.gapy = gapy;
        this.isMandatory = isMandatory;
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            super.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setForeground(list.getForeground());
            Color background = index == -1 ? (this.isMandatory ? Design.CONTROL_BG_MANDATORY : Design.CONTROL_BG) : list.getBackground();
            super.setBackground(background);
        }
        this.setFont(list.getFont());
        this.setPreferredSize(new Dimension(0, this.getFontMetrics(this.getFont()).getHeight() + this.gapy));
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setColor(this.getBackground());
        g22.fillRect(0, 0, this.getWidth(), this.getHeight() + this.gapy);
        g22.setColor(this.getForeground());
        g22.setFont(this.getFont());
        if (this.current == null) {
            return;
        }
        g22.drawString(this.current.toString(), this.gapx, this.getHeight() - this.gapy);
    }

    @Override
    public void setBackground(Color bg) {
    }
}

