/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.IInputField;
import ch.transsoft.edec.ui.pm.model.MaxLineFilter;
import ch.transsoft.edec.ui.pm.model.StringPm;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;

public class StringArea
extends JScrollPane {
    private StringPm model;
    private final JTextArea textArea;
    private Color bgColor = Design.CONTROL_BG;

    public StringArea(StringPm doc, int rows) {
        this(doc, rows, Design.CONTROL_BG);
    }

    public StringArea(StringPm doc, int rows, Color bgColor) {
        this(rows);
        this.bgColor = bgColor;
        doc.setDocumentFilter(new MaxLineFilter(rows, this.textArea));
        this.setModel(doc);
    }

    public StringArea(int rows) {
        super(21, 31);
        this.setBorder(new LineBorder(Design.CONTROL_BORDER, 1));
        this.textArea = new TextArea(rows);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        for (MouseWheelListener mwl : this.getMouseWheelListeners()) {
            this.removeMouseWheelListener(mwl);
        }
        this.repairTraversal();
        this.setViewportView(this.textArea);
    }

    public void setModel(StringPm doc) {
        this.model = doc;
        this.textArea.setDocument(doc);
        this.setErrorState(this.model.getErrorInfo());
        this.addErrorListener();
    }

    private void setErrorState(ErrorInfo info) {
        this.textArea.setToolTipText(info.getMesage());
        if (info.hasError()) {
            this.textArea.setBackground(Design.ERROR_COLOR);
            return;
        }
        if (this.model.isMandatory()) {
            this.textArea.setBackground(Design.CONTROL_BG_MANDATORY);
        } else {
            this.textArea.setBackground(this.bgColor);
        }
    }

    private void addErrorListener() {
        this.model.addErrorListener(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                StringArea.this.setErrorState(errorInfo);
            }
        });
    }

    private void repairTraversal() {
        HashSet<KeyStroke> forwardKeys = new HashSet<KeyStroke>();
        forwardKeys.add(KeyStroke.getKeyStroke(9, 0));
        this.textArea.setFocusTraversalKeys(0, forwardKeys);
        this.textArea.setFocusTraversalKeys(1, null);
    }

    private void affirm() {
        this.model.triggerDataChanged();
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    @Override
    public void setFont(Font font) {
        if (this.textArea == null) {
            return;
        }
        this.textArea.setFont(font);
    }

    private class TextArea
    extends JTextArea
    implements IInputField,
    FocusListener {
        public TextArea(int rows) {
            super(rows, 10);
            this.addFocusListener(this);
        }

        @Override
        public void commit() {
            StringArea.this.affirm();
        }

        @Override
        public void save() {
            StringArea.this.affirm();
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            StringArea.this.affirm();
        }
    }
}

