/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.combo;

import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.pm.model.ISelectionFieldData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SelectionFieldRenderer
extends JComponent
implements ListCellRenderer<Object> {
    private ISelectionFieldData current;
    private final int gapx;
    private final int gapy;
    private final int spacer;
    private final ISelectionFieldRendererContext context;
    private final boolean drawKey;

    public SelectionFieldRenderer(boolean drawKey, int spacer, int gapx, int gapy, ISelectionFieldRendererContext context) {
        this.drawKey = drawKey;
        this.spacer = spacer;
        this.gapx = gapx;
        this.gapy = gapy;
        this.context = context;
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.current = (ISelectionFieldData)value;
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setForeground(list.getForeground());
        }
        if (index == -1) {
            super.setBackground(this.getEditorBackground(isSelected));
        } else {
            super.setBackground(this.getListEntryBackground(list, isSelected));
        }
        this.setFont(list.getFont());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setPreferredSize(new Dimension(this.getTotalWidth(fontMetrics), fontMetrics.getHeight() + this.gapy));
        return this;
    }

    private int getTotalWidth(FontMetrics fontMetrics) {
        if (this.current == null) {
            return this.spacer;
        }
        int descLength = (int)this.getStringWidth(fontMetrics, this.current.getDesc());
        if (!this.current.getKey().isEmpty() && this.drawKey) {
            return descLength + this.spacer;
        }
        return descLength;
    }

    private Color getListEntryBackground(JList<?> list, boolean isSelected) {
        return isSelected ? list.getSelectionBackground() : list.getBackground();
    }

    private Color getEditorBackground(boolean selected) {
        if (this.context.getErrorInfo().hasError()) {
            return selected ? Design.ERROR_SELECTED_COLOR : Design.ERROR_COLOR;
        }
        return this.context.isMandatory() ? Design.CONTROL_BG_MANDATORY : Design.CONTROL_BG;
    }

    private double getStringWidth(FontMetrics fontMetrics, String desc) {
        return fontMetrics.getStringBounds(desc, this.getGraphics()).getWidth();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setColor(this.getBackground());
        g22.fillRect(0, 0, this.getWidth(), this.getHeight() + this.gapy);
        g22.setColor(this.getForeground());
        g22.setFont(this.getFont());
        if (this.current == null) {
            return;
        }
        int gap = 0;
        if (!this.current.getKey().isEmpty() && this.drawKey) {
            g22.drawString(this.current.getKey(), this.gapx, this.getHeight() - this.gapy);
            gap = this.spacer;
        }
        g22.drawString(this.current.getDesc(), this.gapx + gap, this.getHeight() - this.gapy);
    }

    @Override
    public void setBackground(Color bg) {
    }

    public static interface ISelectionFieldRendererContext {
        public ErrorInfo getErrorInfo();

        public boolean isMandatory();
    }
}

