/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.combo;

import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.DefaultComboBoxModel;

public class StateAwareComboBoxModel<E>
extends DefaultComboBoxModel<E> {
    private boolean enabled = true;
    private final ListenerList<IComboStateListener> stateListeners = new ListenerList();
    private final ListenerList<ISelectionChangeListener> selectionListeners = new ListenerList();

    public void setEnabled(boolean value) {
        this.enabled = value;
        this.notifyStateListeners();
    }

    private void notifyStateListeners() {
        for (IComboStateListener listener : this.stateListeners) {
            listener.stateChanged();
        }
    }

    protected boolean getEnabledState() {
        return this.enabled;
    }

    public IDisposable addStateListener(IComboStateListener listener) {
        return this.stateListeners.add(listener);
    }

    public void addSelectionChangeListener(ISelectionChangeListener l2) {
        this.selectionListeners.add(l2);
    }

    private void fireSelectionChanged() {
        for (ISelectionChangeListener listener : this.selectionListeners) {
            listener.selectionChanged();
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        Object currentSelection = this.getSelectedItem();
        super.setSelectedItem(anObject);
        if (currentSelection != null) {
            this.fireSelectionChanged();
        }
    }

    public static interface ISelectionChangeListener {
        public void selectionChanged();
    }

    public static interface IComboStateListener {
        public void stateChanged();
    }
}

