/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.icondisplay;

import ch.transsoft.edec.ui.gui.control.icondisplay.IIconDisplayChangeListener;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplayModel;
import ch.transsoft.edec.ui.img.IconLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class IconDisplay
extends JPanel {
    private static final int GAP = 2;
    private int gap;
    private final IconDisplayModel model;

    public IconDisplay() {
        this(new IconDisplayModel(), 2);
    }

    public IconDisplay(String iconName) {
        this(iconName, 2);
    }

    public IconDisplay(String iconName, int gap) {
        this(new IconDisplayModel(iconName), gap);
    }

    public IconDisplay(ImageIcon icon) {
        this(icon, 2);
    }

    public IconDisplay(ImageIcon icon, int gap) {
        this(new IconDisplayModel(icon), gap);
    }

    public IconDisplay(IconDisplayModel model) {
        this(model, 2);
    }

    public IconDisplay(IconDisplayModel model, int gap) {
        this.model = model;
        this.gap = gap;
        this.setOpaque(false);
        model.addListener(new IIconDisplayChangeListener(){

            @Override
            public void iconChanged(ImageIcon newIcon) {
                IconDisplay.this.repaint();
            }

            @Override
            public void tooltipChanged(String tooltip) {
                IconDisplay.this.setToolTipText(tooltip);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        ImageIcon icon = this.model.getIcon();
        if (icon == null) {
            return;
        }
        Dimension d2 = this.getSize();
        double scale = Math.min((double)d2.width / (double)icon.getIconWidth(), (double)d2.height / (double)icon.getIconHeight());
        double width = (double)icon.getIconWidth() * scale;
        double height = (double)icon.getIconHeight() * scale;
        int x = (int)((double)d2.width - width) / 2 + this.gap;
        int y = (int)((double)d2.height - height) / 2 + this.gap;
        g2.drawImage(icon.getImage(), x, y, (int)width - 2 * this.gap, (int)height - 2 * this.gap, null);
    }

    public void setIcon(ImageIcon result) {
        this.model.setIcon(result);
    }

    public void setIcon(String iconName) {
        this.setIcon(IconLoader.getIcon(iconName));
    }
}

