/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.icondisplay;

import ch.transsoft.edec.ui.gui.control.icondisplay.IIconDisplayChangeListener;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.ImageIcon;

public class IconDisplayModel {
    private ListenerList<IIconDisplayChangeListener> listeners = new ListenerList();
    private ImageIcon icon;

    public IconDisplayModel() {
    }

    public IconDisplayModel(String iconName) {
        this(IconLoader.getIcon(iconName));
    }

    public IconDisplayModel(ImageIcon icon) {
        this.icon = icon;
    }

    public void setIcon(String iconName) {
        this.setIcon(IconLoader.getIcon(iconName));
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.notifyIconChanged();
    }

    private void notifyIconChanged() {
        for (IIconDisplayChangeListener listener : this.listeners) {
            listener.iconChanged(this.icon);
        }
    }

    private void notifyTooltipChanged(String tooltip) {
        for (IIconDisplayChangeListener listener : this.listeners) {
            listener.tooltipChanged(tooltip);
        }
    }

    public IDisposable addListener(IIconDisplayChangeListener listener) {
        return this.listeners.add(listener);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void removeIcon() {
        this.icon = null;
        this.notifyIconChanged();
    }

    public void setToolTip(String message) {
        this.notifyTooltipChanged(message);
    }
}

