/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.ui.gui.Design;
import java.awt.Component;
import javax.swing.JTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class ErrorHighlighter
extends AbstractHighlighter {
    @Override
    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        INode node = (INode)adapter.getValue();
        if (node == null) {
            return component;
        }
        JTable table = (JTable)adapter.getComponent();
        if (this.getParent(node).getErrorInfo().hasError()) {
            component.setBackground(adapter.isSelected() ? Design.ERROR_SELECTED_COLOR : Design.ERROR_COLOR);
        } else {
            component.setBackground(adapter.isSelected() ? table.getSelectionBackground() : table.getBackground());
        }
        return component;
    }

    private INode<?> getParent(INode<?> node) {
        INode<?> current = node;
        while (current != null) {
            if (!((current = current.getParent()) instanceof ListEntry)) continue;
            return current;
        }
        return node;
    }
}

