/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.control.combo.ComboBoxUI;
import ch.transsoft.edec.ui.gui.control.combo.SelectionFieldRenderer;
import ch.transsoft.edec.ui.gui.control.table.CellEditorBase;
import ch.transsoft.edec.ui.gui.control.table.TableComboBox;
import java.awt.Font;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class SelectionCellEditor
extends CellEditorBase
implements TableCellEditor {
    private JComboBox<Object> editor;
    private final int gap;

    public SelectionCellEditor() {
        this(30);
    }

    public SelectionCellEditor(int gap) {
        this.gap = gap;
    }

    @Override
    public JComponent doGetTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editor = new TableComboBox(this);
        this.editor.setUI(new ComboBoxUI());
        this.addData(value);
        this.editor.setRenderer(new SelectionFieldRenderer(true, this.gap, 0, 4, this.createSelectionFieldContext()));
        Font f2 = this.editor.getFont();
        this.editor.setFont(new Font(f2.getName(), 0, f2.getSize()));
        this.addActionListener();
        return this.editor;
    }

    private void addActionListener() {
        this.editor.addActionListener(e2 -> {
            if (e2.getModifiers() == 0) {
                return;
            }
            this.stopCellEditing();
        });
    }

    private SelectionFieldRenderer.ISelectionFieldRendererContext createSelectionFieldContext() {
        return new SelectionFieldRenderer.ISelectionFieldRendererContext(){

            @Override
            public ErrorInfo getErrorInfo() {
                return ErrorInfo.NO_ERROR;
            }

            @Override
            public boolean isMandatory() {
                return false;
            }
        };
    }

    private void addData(Object value) {
        SelectionNode node = (SelectionNode)value;
        if (node.getDomainData().allowEmpty()) {
            this.editor.addItem(DomainValue.getUninitialized());
        }
        for (DomainValue current : node.getDomainData()) {
            this.editor.addItem(current);
        }
        DomainValue current = node.getValue();
        this.editor.setSelectedItem(current.isInitialized() ? current : null);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getSelectedItem();
    }
}

