/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.ui.gui.control.table.EmptyLineComparator;
import ch.transsoft.edec.ui.gui.control.table.Table;
import ch.transsoft.edec.ui.gui.control.table.ToolTipJXTable;
import ch.transsoft.edec.ui.pm.model.IIndexConverter;
import ch.transsoft.edec.ui.pm.model.TablePm;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class SortableTable<T extends ListEntry<T>>
extends Table<T>
implements IIndexConverter {
    private JXTable tableEx;

    public SortableTable(TablePm<T> listPm, int height, ITableAdapter[] adapters) {
        super(listPm, height, adapters);
    }

    public SortableTable(int height, ITableAdapter[] adapters) {
        super(height, adapters);
    }

    @Override
    protected JXTable instantiateTable() {
        this.tableEx = new ToolTipJXTable();
        this.tableEx.setSortable(true);
        return this.tableEx;
    }

    @Override
    public void setModel(TablePm<T> tablePm) {
        super.setModel(tablePm);
        this.getTableModel().setIndexConverter(this);
        this.setComparator();
    }

    private void setComparator() {
        this.tableEx.getColumnExt(0).setSortable(false);
        boolean sortOrderSet = false;
        for (int i2 = 1; i2 < this.tableEx.getColumnCount(); ++i2) {
            TableColumnExt col = this.tableEx.getColumnExt(i2);
            if (!this.getAdapters()[i2 - 1].getColType().equals(StringNode.class)) {
                col.setSortable(false);
                continue;
            }
            col.setComparator(new EmptyLineComparator(this.getTableModel(), this.tableEx, i2));
        }
    }

    @Override
    public int convertRowIndexToModelIndex(int row) {
        return this.tableEx.convertRowIndexToModel(row);
    }

    @Override
    public int convertModelIndexToRowIndex(int index) {
        return this.tableEx.convertRowIndexToView(index);
    }
}

