/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.tabs;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.AppState;
import ch.transsoft.edec.service.app.IAppChangedListener;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.ui.gui.control.tabs.IColorStrategy;
import ch.transsoft.edec.ui.gui.control.tabs.TabbedPane;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.io.File;

public class AppStateAwareTabPane
extends TabbedPane {
    private final IColorStrategy colorStrategy;
    private AppState appState;

    public AppStateAwareTabPane(Disposables disposables, IColorStrategy colorStrategy) {
        Check.assertNotNull(colorStrategy);
        this.colorStrategy = colorStrategy;
        this.init();
        this.addAppStateListener(disposables);
    }

    private void addAppStateListener(Disposables disposables) {
        this.appState = this.getAppService().getAppState();
        disposables.add(this.getAppService().addChangeListener(new IAppChangedListener(){

            @Override
            public void stateChanged(AppState state, File template) {
                AppStateAwareTabPane.this.appState = state;
                AppStateAwareTabPane.this.setColors();
            }

            @Override
            public void sendingChanged(Sending sending) {
            }
        }));
    }

    private IAppService getAppService() {
        return Services.get(IAppService.class);
    }

    @Override
    protected Color getBackgroundColor(int index) {
        return this.isTemplate() ? this.colorStrategy.getTemplateBg(index) : this.colorStrategy.getSendingBg(index);
    }

    @Override
    protected Color getSelectedColor(int index) {
        return this.isTemplate() ? this.colorStrategy.getTemplateSelected(index) : this.colorStrategy.getSendingSelected(index);
    }

    private boolean isTemplate() {
        return this.appState == AppState.template;
    }
}

