/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.tabs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;

public class ButtonTabComponent
extends JPanel {
    private final JTabbedPane pane;
    private TabButton button;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e2) {
            Component component = e2.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            Component component = e2.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ButtonTabComponent(final JTabbedPane pane) {
        super(new FlowLayout(0, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        JLabel label = new JLabel(){

            @Override
            public String getText() {
                int i2 = pane.indexOfTabComponent(ButtonTabComponent.this);
                if (i2 != -1) {
                    return pane.getTitleAt(i2);
                }
                return null;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.button = new TabButton();
        this.add(this.button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public void setModel(JToggleButton.ToggleButtonModel enableModel) {
        this.button.setModel(enableModel);
    }

    private class TabButton
    extends JCheckBox
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int i2 = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (i2 != -1) {
                ButtonTabComponent.this.pane.setSelectedIndex(i2);
            }
        }
    }
}

