/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.evvimport;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.Check;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class DocRenderer
extends JComponent
implements TableCellRenderer {
    private static final ImageIcon pdf = IconLoader.getIcon("icon/pdf-small.png");
    private static final ImageIcon error = IconLoader.getIcon("icon/Error-small.png");
    private static final int ICON_HEIGHT = 16;
    public static final int ICON_RIGHT = 4;
    public static final int COL_WIDTH = 30;
    private ReceiptDocument.State value;
    private Color bgColor = Color.WHITE;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        IntegralNode node = (IntegralNode)value;
        this.value = ReceiptDocument.State.fromIntValue(node.getIntValue());
        this.detectBackgroundColor(node, table, isSelected);
        return this;
    }

    private void detectBackgroundColor(IntegralNode node, JTable table, boolean isSelected) {
        this.bgColor = this.getSpecialBgColor(node, isSelected);
        if (this.bgColor == null) {
            Color selectionBackground = table.getSelectionBackground();
            Color background = table.getBackground();
            this.bgColor = isSelected ? selectionBackground : background;
        }
    }

    protected abstract Color getSpecialBgColor(IntegralNode var1, boolean var2);

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, 30, 25);
        this.paintDoc(g22);
    }

    private void drawIcon(Graphics2D g2, ImageIcon icon, int x) {
        icon.paintIcon(this, g2, x + 2, 4);
    }

    private void drawBorder(Graphics2D g2, int x) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Design.STATUS_BORDER_BRIGHT);
        g2.drawRoundRect(x + 2, 3, 18, 19, 4, 4);
        g2.setColor(Design.STATUS_BORDER);
        g2.drawRoundRect(x + 1, 2, 18, 19, 4, 4);
    }

    private void paintDoc(Graphics2D g2) {
        int size = 5;
        int x = 11;
        int y = 14;
        this.drawBorder(g2, 4);
        switch (this.value) {
            case DOC_NOT_RECEIVED: {
                break;
            }
            case DOC_RECEIVED: {
                this.drawIcon(g2, pdf, 4);
                break;
            }
            case DOC_VALID: {
                this.drawDot(g2, 5, 11, 14, Design.EVV_VALID);
                break;
            }
            case DOC_INVALID: {
                this.drawDot(g2, 5, 11, 14, Design.EVV_INVALID);
                break;
            }
            case DOC_ERROR: {
                this.drawIcon(g2, error, 4);
                break;
            }
            default: {
                Check.fail("unexpected doc-state: " + this.value);
            }
        }
    }

    private void drawDot(Graphics2D g2, int size, int x, int y, Color dotColor) {
        this.drawIcon(g2, pdf, 4);
        g2.setColor(dotColor);
        g2.fillOval(4 + x + 1, y + 1, size, size);
    }
}

