/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.gui.control.searchtable.SearchTable;
import ch.transsoft.edec.ui.gui.evvimport.bordereau.BordereauDocRenderer;
import ch.transsoft.edec.ui.gui.evvimport.bordereau.IBordereauPopupMenuHandler;
import ch.transsoft.edec.ui.gui.sendinglist.DecimalNodeComparator;
import ch.transsoft.edec.ui.gui.sendinglist.EdecDateNodeComparator;
import ch.transsoft.edec.ui.gui.sendinglist.MixedIntegralComparator;
import ch.transsoft.edec.ui.pm.evvimport.bordereau.BordereauIndexTablePmBase;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexTablePmListener;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.TableUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.decorator.SortOrder;

public class BordereauIndexTablePanel
extends JScrollPane {
    private SearchTable table;
    private final BordereauIndexTablePmBase pm;
    private final IBordereauPopupMenuHandler popupMenuHandler;

    public BordereauIndexTablePanel(BordereauIndexTablePmBase pm, IBordereauPopupMenuHandler popupMenuHandler) {
        this.pm = pm;
        this.popupMenuHandler = popupMenuHandler;
        this.table = new SearchTable((TableModel)pm, true);
        pm.setSelectionModel(this.table.getSelectionModel());
        this.setViewportView(this.table);
        this.table.enableFiltering(true);
        this.table.setRowHeight(25);
        this.setAbsoluteWith(this.table.getColumn(0), 30);
        this.table.getColumn(0).setCellRenderer(new BordereauDocRenderer());
        this.table.getColumnExt(0).setSortable(false);
        this.table.getColumnExt(1).setComparator(new EdecDateNodeComparator());
        this.table.setSortOrder(1, SortOrder.DESCENDING);
        this.table.getColumnExt(2).setComparator(new MixedIntegralComparator());
        this.table.getColumnExt(4).setComparator(new MixedIntegralComparator());
        this.table.getColumnExt(5).setComparator(new MixedIntegralComparator());
        this.table.getColumnExt(6).setComparator(new DecimalNodeComparator());
        this.table.getColumnExt(7).setComparator(new MixedIntegralComparator());
        this.table.getColumnExt(8).setComparator(new DecimalNodeComparator());
        this.table.getColumnExt(9).setComparator(new MixedIntegralComparator());
        this.table.getColumnExt(10).setComparator(new DecimalNodeComparator());
        this.addMouseListener();
        this.addPmListener();
        TableUtil.enableRightMouseButtonSelection(this.table);
        this.addPopupMenu();
    }

    private void setAbsoluteWith(TableColumn column, int with) {
        column.setMinWidth(with);
        column.setMaxWidth(with);
    }

    private void addActionListener() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (!BordereauIndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
                if (e2.getKeyChar() != '\n') {
                    return;
                }
                BordereauIndexTablePanel.this.pm.filterReceipts(BordereauIndexTablePanel.this.table.getSelectionIndex());
                e2.consume();
            }
        });
    }

    private void addPopupMenu() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.getButton() == 3) {
                    BordereauIndexTablePanel.this.showMenu(e2);
                }
            }
        });
    }

    private void showMenu(MouseEvent e2) {
        int[] selectionIndices = this.table.getSelectionIndices();
        if (selectionIndices.length == 0) {
            return;
        }
        ArrayList<BordereauEntry> selection = new ArrayList<BordereauEntry>(selectionIndices.length);
        for (int index : selectionIndices) {
            selection.add(this.pm.getIndexEntry(index));
        }
        JPopupMenu menu = new JPopupMenu();
        this.popupMenuHandler.addItems(selection, menu);
        if (menu.getComponentCount() == 0) {
            return;
        }
        try {
            menu.show(e2.getComponent(), e2.getX(), e2.getY());
        }
        catch (Exception ex) {
            Services.get(ILoggingService.class).logSilentWithBugMail(ex, "IndexTablePanel.showMenu threw.");
        }
    }

    private void addPmListener() {
        this.pm.add(new IIndexTablePmListener(){

            @Override
            public void searchTextChanged(String text) {
                BordereauIndexTablePanel.this.table.searchTextChanged(text);
            }

            @Override
            public void searchNext(boolean backwards) {
                BordereauIndexTablePanel.this.table.searchNext(backwards);
            }

            @Override
            public void openCurrentSending() {
                if (!BordereauIndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
            }
        });
    }

    private void addMouseListener() {
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                if (BordereauIndexTablePanel.this.hitsClickableElement(e2)) {
                    Services.get(IGuiService.class).setLinkCursor(true);
                } else {
                    Services.get(IGuiService.class).setLinkCursor(false);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e2) {
                Services.get(IGuiService.class).setLinkCursor(false);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                if (e2.getButton() != 1) {
                    return;
                }
                if (!BordereauIndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
                int row = BordereauIndexTablePanel.this.table.getSelectionIndex();
                if (e2.getClickCount() == 1) {
                    BordereauIndexTablePanel.this.showDocument(row, e2);
                    return;
                }
                if (e2.getClickCount() == 2 && e2.getX() > 30 && BordereauIndexTablePanel.this.table.getEditingRow() == -1) {
                    BordereauIndexTablePanel.this.pm.filterReceipts(BordereauIndexTablePanel.this.table.getSelectionIndex());
                }
            }
        });
    }

    private void showDocument(int row, MouseEvent e2) {
        if (e2.getX() > 60) {
            return;
        }
        BordereauEntry entry = this.pm.getIndexEntry(row);
        if (e2.getX() < 30) {
            DocumentUtil.showBordereau(entry);
        }
    }

    private boolean hitsClickableElement(MouseEvent e2) {
        return e2.getX() < 30;
    }
}

