/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.forms;

import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.tabs.AppStateAwareTabPane;
import ch.transsoft.edec.ui.gui.control.tabs.DefaultColorStrategy;
import ch.transsoft.edec.ui.gui.sending.forms.FormUiHandle;
import ch.transsoft.edec.ui.gui.sending.forms.PagePanel;
import ch.transsoft.edec.ui.pm.sending.forms.FormPm;
import ch.transsoft.edec.ui.pm.sending.forms.PagePm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;

public class FormPanel
extends DefaultPanel {
    private final FormPm formPm;
    private JTabbedPane tabs;
    private final List<PagePanel> pagePanels = new ArrayList<PagePanel>();

    public FormPanel(FormPm formPm, FormUiHandle formUiHandle) {
        this.formPm = formPm;
        this.setLayout(new BorderLayout());
        if (formPm.getFormSides().size() == 1) {
            this.addOneFormSide(formPm.getFormSides().get(0), formUiHandle);
        } else {
            this.addManyFormSides(formUiHandle);
        }
        formPm.addGuiRecreationListener(this::recreatePageContent);
    }

    private void addOneFormSide(PagePm formSidePm, FormUiHandle formUiHandle) {
        Component panel = this.createPagePanel(formSidePm, formUiHandle);
        this.add(panel);
        this.pagePanels.add((PagePanel)panel);
    }

    private void addManyFormSides(FormUiHandle formUiHandle) {
        this.tabs = new AppStateAwareTabPane(this.formPm.getDisposables(), new DefaultColorStrategy());
        this.tabs.setOpaque(false);
        this.add(this.tabs);
        for (PagePm formSide : this.formPm.getFormSides()) {
            Component panel = this.createPagePanel(formSide, formUiHandle);
            this.tabs.addTab(formSide.getName(), panel);
            this.pagePanels.add((PagePanel)panel);
        }
        this.tabs.setSelectedIndex(this.formPm.getSelectedVariant());
        this.tabs.addChangeListener(e2 -> {
            if (this.tabs.getSelectedIndex() == -1) {
                return;
            }
            this.formPm.variantChanged(this.tabs.getSelectedIndex());
        });
    }

    private Component createPagePanel(PagePm pagePm, FormUiHandle formUiHandle) {
        return new PagePanel(pagePm, formUiHandle);
    }

    public void recreatePageContent() {
        for (PagePanel pagePanel : this.pagePanels) {
            pagePanel.recreatePageContent();
        }
    }
}

