/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.forms;

import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.table.ToolTipJXTable;
import ch.transsoft.edec.ui.gui.sending.forms.ErrorAwareBooleanRenderer;
import ch.transsoft.edec.ui.gui.sending.forms.ErrorAwareRenderer;
import ch.transsoft.edec.ui.gui.sending.forms.FormPanel;
import ch.transsoft.edec.ui.gui.sending.forms.FormUiHandle;
import ch.transsoft.edec.ui.pm.sending.forms.FormPm;
import ch.transsoft.edec.ui.pm.sending.forms.FormsPm;
import ch.transsoft.edec.ui.pm.sending.forms.IFormSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JScrollPane;

public class FormsPanel
extends DefaultPanel
implements IFormSelectionListener,
FormUiHandle {
    private final FormsPm formsPm;
    private ToolTipJXTable table;
    private IFormDesc currentFormDesc;
    private FormPanel currentFormPanel;

    public FormsPanel(FormsPm formsPm) {
        this.formsPm = formsPm;
        this.setLayout(new BorderLayout());
        this.add(this.createTable(), "West");
        this.addSelectionListener();
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.addSendingListener();
    }

    private void addSendingListener() {
        this.formsPm.addSendingListener((source, info) -> this.repaint());
    }

    private void addSelectionListener() {
        this.formsPm.addSelectionListener(this);
    }

    private Component createTable() {
        JScrollPane result = new JScrollPane();
        this.table = new ToolTipJXTable();
        result.setViewportView(this.table);
        this.table.setSortable(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 0));
        this.table.setModel(this.formsPm);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.table.setRowHeight(25);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, new ErrorAwareRenderer(this.formsPm));
        this.table.setDefaultRenderer(Boolean.class, new ErrorAwareBooleanRenderer(this.formsPm));
        this.formsPm.setSelectionModel(this.table.getSelectionModel());
        return result;
    }

    @Override
    protected void paintComponent(Graphics g2) {
    }

    @Override
    public void selected(IFormDesc form) {
        this.currentFormDesc = form;
        this.createUi(form);
    }

    @Override
    public void reCreateUi() {
        this.createUi(this.currentFormDesc);
    }

    private void createUi(IFormDesc form) {
        if (this.currentFormPanel != null) {
            this.remove(this.currentFormPanel);
        }
        double currentZoom = this.formsPm.getCurrentFormPm() != null ? this.formsPm.getCurrentFormPm().getZoomScale() : 1.0;
        this.formsPm.setCurrentFormPm(new FormPm(form, this.formsPm.getSending()));
        this.currentFormPanel = new FormPanel(this.formsPm.getCurrentFormPm(), this);
        this.add(this.currentFormPanel);
        this.formsPm.getCurrentFormPm().setZoomScale(currentZoom);
        this.validate();
        this.repaint();
    }
}

