/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.statusline.popmenu;

import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.ALState;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.SendAzaJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.validate.IValidateService;
import java.awt.event.ActionEvent;

public class DownloadAlAgainAction
extends ActionBase {
    private final Sending sending;

    public DownloadAlAgainAction(Sending sending) {
        super(Services.getText(1510), "icon/pdf-small.png", "icon/pdf-big.png");
        this.sending = sending;
        this.setEnabled(Services.get(IConfigService.class).hasCertificate() && sending.getState().getAlState() == ALState.complete);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (!Services.get(IValidateService.class).validate(false)) {
            return;
        }
        ModelNode copy = this.sending.getCopy((ModelNode)null);
        ((Sending)copy).getGoodsDeclaration().getCorrectionCode().setValue("3");
        ((Sending)copy).getGoodsDeclaration().getCorrectionReason().clear();
        String uid = ((Sending)copy).getGoodsDeclaration().getDeclarant().getUid().getValue();
        OperatingMode mode = ((Sending)copy).getOperatingModeValue() == OperatingMode.undefined ? Services.get(IConfigService.class).getOperatingModeForActiveModule() : ((Sending)copy).getOperatingModeValue();
        String guid = Services.get(IConfigService.class).getGuid();
        Services.get(IBackendService.class).put(new SendAzaJob((Sending)copy, guid, mode, uid));
    }
}

