/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist;

import ch.transsoft.edec.model.sending.ALState;
import ch.transsoft.edec.model.sending.EVVState;
import ch.transsoft.edec.model.sending.EvvValidationState;
import ch.transsoft.edec.model.sending.InternalState;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.State;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.img.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StateRenderer
extends JComponent
implements TableCellRenderer {
    private static ImageIcon check = IconLoader.getIcon("icon/Check-green-small.png");
    private static ImageIcon pdf = IconLoader.getIcon("icon/pdf-small.png");
    private static ImageIcon point_green = IconLoader.getIcon("icon/Point-green-small.png");
    private static ImageIcon evv_mailed = IconLoader.getIcon("icon/evv_mailed-small.png");
    private static ImageIcon error = IconLoader.getIcon("icon/Error-small.png");
    private static ImageIcon truck = IconLoader.getIcon("icon/Truck-small.png");
    private static ImageIcon test = IconLoader.getIcon("icon/test-5x15.png");
    private static final int ICON_HEIGHT = 16;
    public static final int AL_POS = 10;
    public static final int INTERNAL_POS = 35;
    public static final int EVV_POS = 60;
    private State state;
    private Color bgColor = Color.WHITE;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        this.state = (State)value;
        this.detectBackgroundColor(table, isSelected);
        return this;
    }

    private void detectBackgroundColor(JTable table, boolean isSelected) {
        Color selectionBackground = table.getSelectionBackground();
        Color background = table.getBackground();
        this.bgColor = Design.getStatusBackground(this.state.getStatus(), isSelected, selectionBackground, background);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, 100, 25);
        if (this.state.getOperatingMode() == OperatingMode.test) {
            this.drawIcon(g22, test, 2);
        }
        this.paintInternalState(g22);
        this.paintAl(g22);
        this.paintEVV(g22);
    }

    private void paintEVV(Graphics2D g2) {
        this.drawBroder(g2, 60);
        if (this.state.getEvvState() == EVVState.undefined) {
            if (this.state.isSelectedState()) {
                this.drawIcon(g2, point_green, 60);
            }
            return;
        }
        if (this.state.getEvvState() == EVVState.error) {
            this.drawIcon(g2, error, 60);
        } else if (this.state.getEvvState() == EVVState.complete) {
            this.drawIcon(g2, this.state.isEvvMailed() ? evv_mailed : pdf, 60);
            if (this.state.getEvvValidationState() == EvvValidationState.undefined) {
                return;
            }
            int size = 5;
            int x = 11;
            int y = 14;
            g2.setColor(this.state.getEvvValidationState() == EvvValidationState.valid ? Design.EVV_VALID : Design.EVV_INVALID);
            g2.fillOval(72, 15, 5, 5);
        }
    }

    private void paintAl(Graphics2D g2) {
        this.drawBroder(g2, 10);
        if (this.state.getAlState() == ALState.undefined) {
            return;
        }
        if (this.state.getAlState() == ALState.error) {
            this.drawIcon(g2, error, 10);
        } else if (this.state.getAlState() == ALState.validated) {
            this.drawIcon(g2, check, 10);
        } else if (this.state.getAlState() == ALState.complete) {
            this.drawIcon(g2, pdf, 10);
        }
    }

    private void drawIcon(Graphics2D g2, ImageIcon icon, int x) {
        icon.paintIcon(this, g2, x + 2, 4);
    }

    private void drawBroder(Graphics2D g2, int x) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Design.STATUS_BORDER_BRIGHT);
        g2.drawRoundRect(x + 2, 3, 18, 19, 4, 4);
        g2.setColor(Design.STATUS_BORDER);
        g2.drawRoundRect(x + 1, 2, 18, 19, 4, 4);
    }

    private void paintInternalState(Graphics2D g2) {
        this.drawBroder(g2, 35);
        if (this.state.getInternalState() == InternalState.undefined) {
            return;
        }
        this.drawIcon(g2, truck, 35);
    }
}

