/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist.popupactions;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.sending.AzaStatusCodes;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.sending.ClearSendingStatusJob;
import ch.transsoft.edec.ui.gui.Design;
import java.awt.event.ActionEvent;
import java.util.List;

public class ClearSendingStatusAction
extends ActionBase {
    private final List<IndexEntry> indexEntries;

    public ClearSendingStatusAction(List<IndexEntry> indexEntries) {
        super(Services.getText(890), Design.CUSTOMS_STATUS_BG_ERROR);
        this.indexEntries = indexEntries;
        boolean containsClearableEntry = this.containsClearable(indexEntries);
        this.setEnabled(containsClearableEntry);
        if (indexEntries.size() > 1) {
            return;
        }
        IndexEntry indexEntry = indexEntries.get(0);
        if (!AzaStatusCodes.manualClearingAllowed(indexEntry.getState().getStatus())) {
            this.setTooltip(Services.getText(892));
            return;
        }
        if (!indexEntry.isOld()) {
            this.setTooltip(Services.getText(893));
            return;
        }
        this.setTooltip(Services.getText(891));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        for (IndexEntry indexEntry : this.indexEntries) {
            if (!this.isClearable(indexEntry)) continue;
            Services.get(IBackendService.class).put(new ClearSendingStatusJob(indexEntry.getSendingId(), indexEntry.getTraderDeclarationNumber().getValue()), false);
        }
    }

    private boolean isClearable(IndexEntry indexEntry) {
        return AzaStatusCodes.manualClearingAllowed(indexEntry.getState().getStatus()) && indexEntry.isOld();
    }

    private boolean containsClearable(List<IndexEntry> indexEntries) {
        for (IndexEntry indexEntry : indexEntries) {
            if (!this.isClearable(indexEntry)) continue;
            return true;
        }
        return false;
    }
}

