/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist.popupactions;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendJob;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import java.awt.event.ActionEvent;

public class DeleteSendingAction
extends ActionBase {
    private final IndexEntry indexEntry;
    private final IBackendJob job;

    public DeleteSendingAction(IndexEntry indexEntry, IBackendJob job) {
        super(Services.getText(1517), DeleteSendingAction.getIcon("icon/Delete-small.png"), DeleteSendingAction.getIcon("icon/Delete-big.png"));
        this.indexEntry = indexEntry;
        this.job = job;
        boolean isDeletable = this.isDeletable();
        this.setTooltip(Services.getText(isDeletable ? 1519 : 1518));
        this.setEnabled(isDeletable);
    }

    private boolean isDeletable() {
        if (this.indexEntry.getState().hasEvv()) {
            return false;
        }
        if (this.indexEntry.getState().isSelectedState()) {
            return false;
        }
        if (this.indexEntry.isOld()) {
            return true;
        }
        if (!this.indexEntry.getState().hasAl()) {
            return true;
        }
        return !this.indexEntry.getState().isProduction();
    }

    private Sending getCurrentSending() {
        return Services.get(IAppService.class).getCurrentSending();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (DialogUtil.showDeleteDialogt(Services.format(1520, this.indexEntry.getTraderDeclarationNumber().getValue()), Services.getText(1517)) != 0) {
            return;
        }
        Services.get(IBackendService.class).put(this.job);
        if (this.getCurrentSending().isSending(this.indexEntry)) {
            Services.get(IAppService.class).newSending();
        }
    }
}

