/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist.popupactions;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.MoveSendingToArchiveJob;
import java.awt.event.ActionEvent;
import java.util.List;

public class MoveSendingToArchiveAction
extends ActionBase {
    private final List<IndexEntry> indexEntries;

    public MoveSendingToArchiveAction(List<IndexEntry> indexEntries) {
        super(Services.getText(1521), MoveSendingToArchiveAction.getIcon("icon/Archive-small.png"), MoveSendingToArchiveAction.getIcon("icon/Archive-big.png"));
        this.indexEntries = indexEntries;
        boolean actionEnabled = this.containsArchivable();
        this.setEnabled(actionEnabled);
        if (indexEntries.size() > 1) {
            return;
        }
        this.setTooltip(Services.getText(actionEnabled ? 1521 : 1522));
    }

    private boolean readyForArchive(IndexEntry indexEntry) {
        if (indexEntry.isOld()) {
            return true;
        }
        if (!indexEntry.getState().isProduction()) {
            return true;
        }
        if (!indexEntry.getState().hasAl()) {
            return true;
        }
        return indexEntry.getState().hasEvv();
    }

    private boolean containsArchivable() {
        for (IndexEntry indexEntry : this.indexEntries) {
            if (!this.readyForArchive(indexEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        for (IndexEntry indexEntry : this.indexEntries) {
            if (!this.readyForArchive(indexEntry)) continue;
            Services.get(IBackendService.class).put(new MoveSendingToArchiveJob(indexEntry.getSendingId()));
        }
    }
}

