/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist.popupactions;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.ValidateEvvJob;
import java.awt.event.ActionEvent;
import java.util.List;

public class ValidateEvvAction
extends ActionBase {
    private final List<IndexEntry> indexEntries;

    public ValidateEvvAction(List<IndexEntry> indexEntries) {
        super(Services.getText(887), "icon/Check-green-small.png", "icon/Check-green-32x32.png");
        this.indexEntries = indexEntries;
        if (!this.selectionContainsEvv()) {
            this.setTooltip(Services.getText(633));
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        for (IndexEntry indexEntry : this.indexEntries) {
            if (!this.hasEvv(indexEntry)) continue;
            Services.get(IBackendService.class).put(new ValidateEvvJob(indexEntry.getSendingId()), true);
        }
    }

    private boolean selectionContainsEvv() {
        for (IndexEntry indexEntry : this.indexEntries) {
            if (!this.hasEvv(indexEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEvv(IndexEntry entry) {
        return entry.getState().hasEvv();
    }
}

