/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.img;

import ch.transsoft.edec.ui.img.ScaledPdfImage;
import ch.transsoft.edec.util.Check;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class IconLoader {
    private static final Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();

    public static ImageIcon getIcon(String name) {
        ImageIcon result = iconCache.get(name);
        if (result == null) {
            result = IconLoader.loadIcon(name);
            iconCache.put(name, result);
        }
        return result;
    }

    private static ImageIcon loadIcon(String name) {
        URL imageURL = IconLoader.getUrl(name);
        Check.assertNotNull(imageURL, "icon not found: ", name);
        return new ImageIcon(imageURL);
    }

    public static URL getUrl(String name) {
        return IconLoader.class.getResource(name);
    }

    public static ImageIcon getMonochromaticIcon(Color color, int width, int height) {
        String name = color.toString();
        ImageIcon result = iconCache.get(name);
        if (result == null) {
            result = IconLoader.createMonochromaticIcon(color, width, height);
            iconCache.put(name, result);
        }
        return result;
    }

    private static ImageIcon createMonochromaticIcon(Color color, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(color);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return new ImageIcon(image);
    }

    public static ScaledPdfImage getPdfImg(String name, double formScale, double volatileScale) {
        ScaledPdfImage scaledPdfImage;
        block9: {
            InputStream inputStream = IconLoader.class.getResourceAsStream(name);
            try {
                if (inputStream == null) {
                    throw new RuntimeException("Did not find resource: " + name);
                }
                PDDocument doc = Loader.loadPDF(inputStream.readAllBytes());
                PDFRenderer pdfRenderer = new PDFRenderer(doc);
                BufferedImage bi = pdfRenderer.renderImage(0, (float)(formScale * volatileScale));
                doc.close();
                scaledPdfImage = new ScaledPdfImage(volatileScale, bi);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e2) {
                    Check.fail(e2, "Error when reading image from pdf-file");
                    throw new RuntimeException();
                }
            }
            inputStream.close();
        }
        return scaledPdfImage;
    }

    public static ImageIcon getPdfIcon(String resource) {
        ImageIcon result = iconCache.get(resource);
        if (result == null) {
            result = new ImageIcon(IconLoader.getPdfImg(resource, 0.1, 1.0).getImage());
            iconCache.put(resource, result);
        }
        return result;
    }
}

