/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.IModulePm;
import ch.transsoft.edec.ui.pm.sending.SendingPm;
import ch.transsoft.edec.ui.pm.sendinglist.ArchiveTablePm;
import ch.transsoft.edec.ui.pm.sendinglist.IndexTablePm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class ExportPm
implements IModulePm {
    private final Disposables disposables = new Disposables();
    private final IndexTablePm indexPm;
    private final ArchiveTablePm archivePm;
    private SendingPm currentSendingPm;

    public ExportPm() {
        SimpleDocument searchModel = new SimpleDocument();
        searchModel.setText(Services.getText(1556));
        this.indexPm = new IndexTablePm(searchModel);
        this.archivePm = new ArchiveTablePm(searchModel);
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public void add(IDisposable disposable) {
        this.disposables.add(disposable);
    }

    public SendingPm getCurrentSendingPm() {
        return this.currentSendingPm;
    }

    public boolean hasCurrentSending() {
        return this.currentSendingPm != null;
    }

    public Disposables getDisposables() {
        return this.disposables;
    }

    public void createNewSendingPm(Sending sending) {
        this.currentSendingPm = new SendingPm(sending);
    }

    public IndexTablePm getIndexPm() {
        return this.indexPm;
    }

    public ArchiveTablePm getArchivePm() {
        return this.archivePm;
    }

    @Override
    public void initialize() {
        this.indexPm.initialize();
        this.archivePm.initialize();
    }
}

