/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.index.IIndexChangeListener;
import ch.transsoft.edec.service.index.bordereau.IBordereauService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.evvimport.bordereau.BordereauIndexTablePmBase;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexSearchPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class BordereauIndexTablePm
extends BordereauIndexTablePmBase
implements IPm,
IIndexSearchPm,
IDisposable {
    private BordereauIndex index;
    private final Disposables disposables = new Disposables();

    public BordereauIndexTablePm(SimpleDocument searchModel) {
        super(searchModel);
        this.index = NodeFactory.create(BordereauIndex.class);
        this.addListener();
    }

    public void initialize() {
        Services.get(IBordereauService.class).readIndex();
    }

    private void addListener() {
        this.disposables.add(Services.get(IBordereauService.class).add(new IIndexChangeListener<BordereauEntry, BordereauIndex>(){

            @Override
            public void changed(BordereauIndex newIndex) {
                Check.assertNotNull(newIndex);
                BordereauIndexTablePm.this.index = newIndex;
                BordereauIndexTablePm.this.fireTableDataChangedRestoreSelection();
            }

            @Override
            public void clear() {
                BordereauIndexTablePm.this.index = NodeFactory.create(BordereauIndex.class);
                BordereauIndexTablePm.this.fireTableDataChanged();
            }
        }));
    }

    @Override
    public int getRowCount() {
        return this.index.getEntryList().size();
    }

    @Override
    public BordereauEntry getIndexEntry(int row) {
        return this.index.getEntryList().get(row);
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

